/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTagsRequest extends MachineLearningRequest implements
        ToCopyableBuilder<DescribeTagsRequest.Builder, DescribeTagsRequest> {
    private final String resourceId;

    private final String resourceType;

    private DescribeTagsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The ID of the ML object. For example, <code>exampleModelId</code>.
     * </p>
     * 
     * @return The ID of the ML object. For example, <code>exampleModelId</code>.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of the ML object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the ML object.
     * @see TaggableResourceType
     */
    public TaggableResourceType resourceType() {
        return TaggableResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the ML object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TaggableResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the ML object.
     * @see TaggableResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsRequest)) {
            return false;
        }
        DescribeTagsRequest other = (DescribeTagsRequest) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceTypeString(), other.resourceTypeString());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTagsRequest").add("ResourceId", resourceId()).add("ResourceType", resourceTypeString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.of(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningRequest.Builder, CopyableBuilder<Builder, DescribeTagsRequest> {
        /**
         * <p>
         * The ID of the ML object. For example, <code>exampleModelId</code>.
         * </p>
         * 
         * @param resourceId
         *        The ID of the ML object. For example, <code>exampleModelId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of the ML object.
         * </p>
         * 
         * @param resourceType
         *        The type of the ML object.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the ML object.
         * </p>
         * 
         * @param resourceType
         *        The type of the ML object.
         * @see TaggableResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaggableResourceType
         */
        Builder resourceType(TaggableResourceType resourceType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsRequest model) {
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TaggableResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeTagsRequest build() {
            return new DescribeTagsRequest(this);
        }
    }
}
