/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.Prediction;

@SdkInternalApi
public class PredictionMarshaller {
    private static final MarshallingInfo<String> PREDICTEDLABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predictedLabel").build();
    private static final MarshallingInfo<Float> PREDICTEDVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predictedValue").build();
    private static final MarshallingInfo<Map> PREDICTEDSCORES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predictedScores").build();
    private static final MarshallingInfo<Map> DETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("details").build();
    private static final PredictionMarshaller INSTANCE = new PredictionMarshaller();

    public static PredictionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Prediction prediction, ProtocolMarshaller protocolMarshaller) {
        if (prediction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)prediction.predictedLabel(), PREDICTEDLABEL_BINDING);
            protocolMarshaller.marshall((Object)prediction.predictedValue(), PREDICTEDVALUE_BINDING);
            protocolMarshaller.marshall(prediction.predictedScores(), PREDICTEDSCORES_BINDING);
            protocolMarshaller.marshall(prediction.detailsStrings(), DETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

