/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.DataSource;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;

public final class DescribeDataSourcesPaginator
implements SdkIterable<DescribeDataSourcesResponse> {
    private final MachineLearningClient client;
    private final DescribeDataSourcesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDataSourcesPaginator(MachineLearningClient client, DescribeDataSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDataSourcesResponseFetcher();
    }

    public Iterator<DescribeDataSourcesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DataSource> results() {
        Function<DescribeDataSourcesResponse, Iterator> getIterator = response -> response != null ? response.results().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDataSourcesResponseFetcher
    implements NextPageFetcher<DescribeDataSourcesResponse> {
        private DescribeDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSourcesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeDataSourcesResponse nextPage(DescribeDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSourcesPaginator.this.client.describeDataSources(DescribeDataSourcesPaginator.this.firstRequest);
            }
            return DescribeDataSourcesPaginator.this.client.describeDataSources((DescribeDataSourcesRequest)((Object)DescribeDataSourcesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

