/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.Evaluation;

@SdkInternalApi
public class EvaluationMarshaller {
    private static final MarshallingInfo<String> EVALUATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationId").build();
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").build();
    private static final MarshallingInfo<String> EVALUATIONDATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationDataSourceId").build();
    private static final MarshallingInfo<String> INPUTDATALOCATIONS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataLocationS3").build();
    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> PERFORMANCEMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PerformanceMetrics").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").build();
    private static final MarshallingInfo<Instant> FINISHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").build();
    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").build();
    private static final EvaluationMarshaller INSTANCE = new EvaluationMarshaller();

    public static EvaluationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Evaluation evaluation, ProtocolMarshaller protocolMarshaller) {
        if (evaluation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)evaluation.evaluationId(), EVALUATIONID_BINDING);
            protocolMarshaller.marshall((Object)evaluation.mlModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall((Object)evaluation.evaluationDataSourceId(), EVALUATIONDATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)evaluation.inputDataLocationS3(), INPUTDATALOCATIONS3_BINDING);
            protocolMarshaller.marshall((Object)evaluation.createdByIamUser(), CREATEDBYIAMUSER_BINDING);
            protocolMarshaller.marshall((Object)evaluation.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)evaluation.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)evaluation.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)evaluation.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)evaluation.performanceMetrics(), PERFORMANCEMETRICS_BINDING);
            protocolMarshaller.marshall((Object)evaluation.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)evaluation.computeTime(), COMPUTETIME_BINDING);
            protocolMarshaller.marshall((Object)evaluation.finishedAt(), FINISHEDAT_BINDING);
            protocolMarshaller.marshall((Object)evaluation.startedAt(), STARTEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

