/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.BatchPrediction;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;

public final class DescribeBatchPredictionsPaginator
implements SdkIterable<DescribeBatchPredictionsResponse> {
    private final MachineLearningClient client;
    private final DescribeBatchPredictionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeBatchPredictionsPaginator(MachineLearningClient client, DescribeBatchPredictionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeBatchPredictionsResponseFetcher();
    }

    public Iterator<DescribeBatchPredictionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<BatchPrediction> results() {
        Function<DescribeBatchPredictionsResponse, Iterator> getIterator = response -> response != null ? response.results().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeBatchPredictionsResponseFetcher
    implements NextPageFetcher<DescribeBatchPredictionsResponse> {
        private DescribeBatchPredictionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBatchPredictionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeBatchPredictionsResponse nextPage(DescribeBatchPredictionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBatchPredictionsPaginator.this.client.describeBatchPredictions(DescribeBatchPredictionsPaginator.this.firstRequest);
            }
            return DescribeBatchPredictionsPaginator.this.client.describeBatchPredictions((DescribeBatchPredictionsRequest)((Object)DescribeBatchPredictionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

