/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;
import software.amazon.awssdk.services.machinelearning.transform.RDSMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RDSMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, RDSMetadata> {
    private final RDSDatabase database;
    private final String databaseUserName;
    private final String selectSqlQuery;
    private final String resourceRole;
    private final String serviceRole;
    private final String dataPipelineId;

    private RDSMetadata(BuilderImpl builder) {
        this.database = builder.database;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.resourceRole = builder.resourceRole;
        this.serviceRole = builder.serviceRole;
        this.dataPipelineId = builder.dataPipelineId;
    }

    public RDSDatabase database() {
        return this.database;
    }

    public String databaseUserName() {
        return this.databaseUserName;
    }

    public String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public String resourceRole() {
        return this.resourceRole;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public String dataPipelineId() {
        return this.dataPipelineId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectSqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPipelineId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSMetadata)) {
            return false;
        }
        RDSMetadata other = (RDSMetadata)obj;
        return Objects.equals(this.database(), other.database()) && Objects.equals(this.databaseUserName(), other.databaseUserName()) && Objects.equals(this.selectSqlQuery(), other.selectSqlQuery()) && Objects.equals(this.resourceRole(), other.resourceRole()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.dataPipelineId(), other.dataPipelineId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.database() != null) {
            sb.append("Database: ").append(this.database()).append(",");
        }
        if (this.databaseUserName() != null) {
            sb.append("DatabaseUserName: ").append(this.databaseUserName()).append(",");
        }
        if (this.selectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(this.selectSqlQuery()).append(",");
        }
        if (this.resourceRole() != null) {
            sb.append("ResourceRole: ").append(this.resourceRole()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.dataPipelineId() != null) {
            sb.append("DataPipelineId: ").append(this.dataPipelineId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Database": {
                return Optional.of(clazz.cast(this.database()));
            }
            case "DatabaseUserName": {
                return Optional.of(clazz.cast(this.databaseUserName()));
            }
            case "SelectSqlQuery": {
                return Optional.of(clazz.cast(this.selectSqlQuery()));
            }
            case "ResourceRole": {
                return Optional.of(clazz.cast(this.resourceRole()));
            }
            case "ServiceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
            case "DataPipelineId": {
                return Optional.of(clazz.cast(this.dataPipelineId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private RDSDatabase database;
        private String databaseUserName;
        private String selectSqlQuery;
        private String resourceRole;
        private String serviceRole;
        private String dataPipelineId;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSMetadata model) {
            this.database(model.database);
            this.databaseUserName(model.databaseUserName);
            this.selectSqlQuery(model.selectSqlQuery);
            this.resourceRole(model.resourceRole);
            this.serviceRole(model.serviceRole);
            this.dataPipelineId(model.dataPipelineId);
        }

        public final RDSDatabase.Builder getDatabase() {
            return this.database != null ? this.database.toBuilder() : null;
        }

        @Override
        public final Builder database(RDSDatabase database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(RDSDatabase.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        public final String getDatabaseUserName() {
            return this.databaseUserName;
        }

        @Override
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public final String getResourceRole() {
            return this.resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getDataPipelineId() {
            return this.dataPipelineId;
        }

        @Override
        public final Builder dataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
            return this;
        }

        public final void setDataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
        }

        public RDSMetadata build() {
            return new RDSMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RDSMetadata> {
        public Builder database(RDSDatabase var1);

        default public Builder database(Consumer<RDSDatabase.Builder> database) {
            return this.database((RDSDatabase)((RDSDatabase.Builder)RDSDatabase.builder().apply(database)).build());
        }

        public Builder databaseUserName(String var1);

        public Builder selectSqlQuery(String var1);

        public Builder resourceRole(String var1);

        public Builder serviceRole(String var1);

        public Builder dataPipelineId(String var1);
    }
}

