/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateBatchPredictionRequest extends MachineLearningRequest implements
        ToCopyableBuilder<UpdateBatchPredictionRequest.Builder, UpdateBatchPredictionRequest> {
    private final String batchPredictionId;

    private final String batchPredictionName;

    private UpdateBatchPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.batchPredictionId = builder.batchPredictionId;
        this.batchPredictionName = builder.batchPredictionName;
    }

    /**
     * <p>
     * The ID assigned to the <code>BatchPrediction</code> during creation.
     * </p>
     * 
     * @return The ID assigned to the <code>BatchPrediction</code> during creation.
     */
    public String batchPredictionId() {
        return batchPredictionId;
    }

    /**
     * <p>
     * A new user-supplied name or description of the <code>BatchPrediction</code>.
     * </p>
     * 
     * @return A new user-supplied name or description of the <code>BatchPrediction</code>.
     */
    public String batchPredictionName() {
        return batchPredictionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionId());
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBatchPredictionRequest)) {
            return false;
        }
        UpdateBatchPredictionRequest other = (UpdateBatchPredictionRequest) obj;
        return Objects.equals(batchPredictionId(), other.batchPredictionId())
                && Objects.equals(batchPredictionName(), other.batchPredictionName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (batchPredictionId() != null) {
            sb.append("BatchPredictionId: ").append(batchPredictionId()).append(",");
        }
        if (batchPredictionName() != null) {
            sb.append("BatchPredictionName: ").append(batchPredictionName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.of(clazz.cast(batchPredictionId()));
        case "BatchPredictionName":
            return Optional.of(clazz.cast(batchPredictionName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningRequest.Builder, CopyableBuilder<Builder, UpdateBatchPredictionRequest> {
        /**
         * <p>
         * The ID assigned to the <code>BatchPrediction</code> during creation.
         * </p>
         * 
         * @param batchPredictionId
         *        The ID assigned to the <code>BatchPrediction</code> during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);

        /**
         * <p>
         * A new user-supplied name or description of the <code>BatchPrediction</code>.
         * </p>
         * 
         * @param batchPredictionName
         *        A new user-supplied name or description of the <code>BatchPrediction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionName(String batchPredictionName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String batchPredictionId;

        private String batchPredictionName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBatchPredictionRequest model) {
            batchPredictionId(model.batchPredictionId);
            batchPredictionName(model.batchPredictionName);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        public final String getBatchPredictionName() {
            return batchPredictionName;
        }

        @Override
        public final Builder batchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
            return this;
        }

        public final void setBatchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateBatchPredictionRequest build() {
            return new UpdateBatchPredictionRequest(this);
        }
    }
}
