/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PredictRequest extends MachineLearningRequest implements ToCopyableBuilder<PredictRequest.Builder, PredictRequest> {
    private final String mlModelId;

    private final Map<String, String> record;

    private final String predictEndpoint;

    private PredictRequest(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.record = builder.record;
        this.predictEndpoint = builder.predictEndpoint;
    }

    /**
     * <p>
     * A unique identifier of the <code>MLModel</code>.
     * </p>
     * 
     * @return A unique identifier of the <code>MLModel</code>.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * Returns the value of the Record property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Record property for this object.
     */
    public Map<String, String> record() {
        return record;
    }

    /**
     * Returns the value of the PredictEndpoint property for this object.
     * 
     * @return The value of the PredictEndpoint property for this object.
     */
    public String predictEndpoint() {
        return predictEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(record());
        hashCode = 31 * hashCode + Objects.hashCode(predictEndpoint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictRequest)) {
            return false;
        }
        PredictRequest other = (PredictRequest) obj;
        return Objects.equals(mlModelId(), other.mlModelId()) && Objects.equals(record(), other.record())
                && Objects.equals(predictEndpoint(), other.predictEndpoint());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (record() != null) {
            sb.append("Record: ").append(record()).append(",");
        }
        if (predictEndpoint() != null) {
            sb.append("PredictEndpoint: ").append(predictEndpoint()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.of(clazz.cast(mlModelId()));
        case "Record":
            return Optional.of(clazz.cast(record()));
        case "PredictEndpoint":
            return Optional.of(clazz.cast(predictEndpoint()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningRequest.Builder, CopyableBuilder<Builder, PredictRequest> {
        /**
         * <p>
         * A unique identifier of the <code>MLModel</code>.
         * </p>
         * 
         * @param mlModelId
         *        A unique identifier of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * Sets the value of the Record property for this object.
         *
         * @param record
         *        The new value for the Record property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Map<String, String> record);

        /**
         * Sets the value of the PredictEndpoint property for this object.
         *
         * @param predictEndpoint
         *        The new value for the PredictEndpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictEndpoint(String predictEndpoint);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String mlModelId;

        private Map<String, String> record;

        private String predictEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictRequest model) {
            mlModelId(model.mlModelId);
            record(model.record);
            predictEndpoint(model.predictEndpoint);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final Map<String, String> getRecord() {
            return record;
        }

        @Override
        public final Builder record(Map<String, String> record) {
            this.record = RecordCopier.copy(record);
            return this;
        }

        public final void setRecord(Map<String, String> record) {
            this.record = RecordCopier.copy(record);
        }

        public final String getPredictEndpoint() {
            return predictEndpoint;
        }

        @Override
        public final Builder predictEndpoint(String predictEndpoint) {
            this.predictEndpoint = predictEndpoint;
            return this;
        }

        public final void setPredictEndpoint(String predictEndpoint) {
            this.predictEndpoint = predictEndpoint;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PredictRequest build() {
            return new PredictRequest(this);
        }
    }
}
