/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeMLModels</code> operation. The content is essentially a list of
 * <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMLModelsResponse extends MachineLearningResponse implements
        ToCopyableBuilder<DescribeMLModelsResponse.Builder, DescribeMLModelsResponse> {
    private final List<MLModel> results;

    private final String nextToken;

    private DescribeMLModelsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>MLModel</code> that meet the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>MLModel</code> that meet the search criteria.
     */
    public List<MLModel> results() {
        return results;
    }

    /**
     * <p>
     * The ID of the next page in the paginated results that indicates at least one more page follows.
     * </p>
     * 
     * @return The ID of the next page in the paginated results that indicates at least one more page follows.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(results());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMLModelsResponse)) {
            return false;
        }
        DescribeMLModelsResponse other = (DescribeMLModelsResponse) obj;
        return Objects.equals(results(), other.results()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (results() != null) {
            sb.append("Results: ").append(results()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.of(clazz.cast(results()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, DescribeMLModelsResponse> {
        /**
         * <p>
         * A list of <code>MLModel</code> that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>MLModel</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<MLModel> results);

        /**
         * <p>
         * A list of <code>MLModel</code> that meet the search criteria.
         * </p>
         * 
         * @param results
         *        A list of <code>MLModel</code> that meet the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(MLModel... results);

        /**
         * <p>
         * The ID of the next page in the paginated results that indicates at least one more page follows.
         * </p>
         * 
         * @param nextToken
         *        The ID of the next page in the paginated results that indicates at least one more page follows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private List<MLModel> results;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMLModelsResponse model) {
            results(model.results);
            nextToken(model.nextToken);
        }

        public final Collection<MLModel.Builder> getResults() {
            return results != null ? results.stream().map(MLModel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<MLModel> results) {
            this.results = MLModelsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(MLModel... results) {
            results(Arrays.asList(results));
            return this;
        }

        public final void setResults(Collection<MLModel.BuilderImpl> results) {
            this.results = MLModelsCopier.copyFromBuilder(results);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMLModelsResponse build() {
            return new DescribeMLModelsResponse(this);
        }
    }
}
