/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DeleteMLModel</code> operation.
 * </p>
 * <p>
 * You can use the <code>GetMLModel</code> operation and check the value of the <code>Status</code> parameter to see
 * whether an <code>MLModel</code> is marked as <code>DELETED</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteMLModelResponse extends MachineLearningResponse implements
        ToCopyableBuilder<DeleteMLModelResponse.Builder, DeleteMLModelResponse> {
    private final String mlModelId;

    private DeleteMLModelResponse(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value
     * of the <code>MLModelID</code> in the request.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to
     *         the value of the <code>MLModelID</code> in the request.
     */
    public String mlModelId() {
        return mlModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMLModelResponse)) {
            return false;
        }
        DeleteMLModelResponse other = (DeleteMLModelResponse) obj;
        return Objects.equals(mlModelId(), other.mlModelId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.of(clazz.cast(mlModelId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, DeleteMLModelResponse> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the
         * value of the <code>MLModelID</code> in the request.
         * </p>
         * 
         * @param mlModelId
         *        A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical
         *        to the value of the <code>MLModelID</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String mlModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMLModelResponse model) {
            mlModelId(model.mlModelId);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        @Override
        public DeleteMLModelResponse build() {
            return new DeleteMLModelResponse(this);
        }
    }
}
