/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>UpdateBatchPrediction</code> operation.
 * </p>
 * <p>
 * You can see the updated content by using the <code>GetBatchPrediction</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateBatchPredictionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateBatchPredictionResponse.Builder, UpdateBatchPredictionResponse> {
    private final String batchPredictionId;

    private UpdateBatchPredictionResponse(BuilderImpl builder) {
        this.batchPredictionId = builder.batchPredictionId;
    }

    /**
     * <p>
     * The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to the value
     * of the <code>BatchPredictionId</code> in the request.
     * </p>
     * 
     * @return The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to
     *         the value of the <code>BatchPredictionId</code> in the request.
     */
    public String batchPredictionId() {
        return batchPredictionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBatchPredictionResponse)) {
            return false;
        }
        UpdateBatchPredictionResponse other = (UpdateBatchPredictionResponse) obj;
        return Objects.equals(batchPredictionId(), other.batchPredictionId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (batchPredictionId() != null) {
            sb.append("BatchPredictionId: ").append(batchPredictionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.of(clazz.cast(batchPredictionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateBatchPredictionResponse> {
        /**
         * <p>
         * The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to the
         * value of the <code>BatchPredictionId</code> in the request.
         * </p>
         * 
         * @param batchPredictionId
         *        The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to
         *        the value of the <code>BatchPredictionId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);
    }

    static final class BuilderImpl implements Builder {
        private String batchPredictionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBatchPredictionResponse model) {
            batchPredictionId(model.batchPredictionId);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        @Override
        public UpdateBatchPredictionResponse build() {
            return new UpdateBatchPredictionResponse(this);
        }
    }
}
