/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RDSDatabaseCredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The database credentials to connect to a database on an RDS DB instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RDSDatabaseCredentials implements StructuredPojo,
        ToCopyableBuilder<RDSDatabaseCredentials.Builder, RDSDatabaseCredentials> {
    private final String username;

    private final String password;

    private RDSDatabaseCredentials(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
    }

    /**
     * Returns the value of the Username property for this object.
     * 
     * @return The value of the Username property for this object.
     */
    public String username() {
        return username;
    }

    /**
     * Returns the value of the Password property for this object.
     * 
     * @return The value of the Password property for this object.
     */
    public String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((username() == null) ? 0 : username().hashCode());
        hashCode = 31 * hashCode + ((password() == null) ? 0 : password().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDatabaseCredentials)) {
            return false;
        }
        RDSDatabaseCredentials other = (RDSDatabaseCredentials) obj;
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        if (other.password() == null ^ this.password() == null) {
            return false;
        }
        if (other.password() != null && !other.password().equals(this.password())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (username() != null) {
            sb.append("Username: ").append(username()).append(",");
        }
        if (password() != null) {
            sb.append("Password: ").append(password()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.of(clazz.cast(username()));
        case "Password":
            return Optional.of(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDatabaseCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RDSDatabaseCredentials> {
        /**
         * Sets the value of the Username property for this object.
         *
         * @param username
         *        The new value for the Username property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * Sets the value of the Password property for this object.
         *
         * @param password
         *        The new value for the Password property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDatabaseCredentials model) {
            username(model.username);
            password(model.password);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public RDSDatabaseCredentials build() {
            return new RDSDatabaseCredentials(this);
        }
    }
}
