/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>DeleteRealtimeEndpoint</code> operation.
 * </p>
 * <p>
 * The result contains the <code>MLModelId</code> and the endpoint information for the <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteRealtimeEndpointResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteRealtimeEndpointResponse.Builder, DeleteRealtimeEndpointResponse> {
    private final String mlModelId;

    private final RealtimeEndpointInfo realtimeEndpointInfo;

    private DeleteRealtimeEndpointResponse(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.realtimeEndpointInfo = builder.realtimeEndpointInfo;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value
     * of the <code>MLModelId</code> in the request.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to
     *         the value of the <code>MLModelId</code> in the request.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The endpoint information of the <code>MLModel</code>
     * </p>
     * 
     * @return The endpoint information of the <code>MLModel</code>
     */
    public RealtimeEndpointInfo realtimeEndpointInfo() {
        return realtimeEndpointInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mlModelId() == null) ? 0 : mlModelId().hashCode());
        hashCode = 31 * hashCode + ((realtimeEndpointInfo() == null) ? 0 : realtimeEndpointInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRealtimeEndpointResponse)) {
            return false;
        }
        DeleteRealtimeEndpointResponse other = (DeleteRealtimeEndpointResponse) obj;
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.realtimeEndpointInfo() == null ^ this.realtimeEndpointInfo() == null) {
            return false;
        }
        if (other.realtimeEndpointInfo() != null && !other.realtimeEndpointInfo().equals(this.realtimeEndpointInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (realtimeEndpointInfo() != null) {
            sb.append("RealtimeEndpointInfo: ").append(realtimeEndpointInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.of(clazz.cast(mlModelId()));
        case "RealtimeEndpointInfo":
            return Optional.of(clazz.cast(realtimeEndpointInfo()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteRealtimeEndpointResponse> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the
         * value of the <code>MLModelId</code> in the request.
         * </p>
         * 
         * @param mlModelId
         *        A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical
         *        to the value of the <code>MLModelId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The endpoint information of the <code>MLModel</code>
         * </p>
         * 
         * @param realtimeEndpointInfo
         *        The endpoint information of the <code>MLModel</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realtimeEndpointInfo(RealtimeEndpointInfo realtimeEndpointInfo);
    }

    static final class BuilderImpl implements Builder {
        private String mlModelId;

        private RealtimeEndpointInfo realtimeEndpointInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRealtimeEndpointResponse model) {
            mlModelId(model.mlModelId);
            realtimeEndpointInfo(model.realtimeEndpointInfo);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final RealtimeEndpointInfo.Builder getRealtimeEndpointInfo() {
            return realtimeEndpointInfo != null ? realtimeEndpointInfo.toBuilder() : null;
        }

        @Override
        public final Builder realtimeEndpointInfo(RealtimeEndpointInfo realtimeEndpointInfo) {
            this.realtimeEndpointInfo = realtimeEndpointInfo;
            return this;
        }

        public final void setRealtimeEndpointInfo(RealtimeEndpointInfo.BuilderImpl realtimeEndpointInfo) {
            this.realtimeEndpointInfo = realtimeEndpointInfo != null ? realtimeEndpointInfo.build() : null;
        }

        @Override
        public DeleteRealtimeEndpointResponse build() {
            return new DeleteRealtimeEndpointResponse(this);
        }
    }
}
