/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DeleteEvaluation</code> operation. The output indicates that Amazon Machine Learning
 * (Amazon ML) received the request.
 * </p>
 * <p>
 * You can use the <code>GetEvaluation</code> operation and check the value of the <code>Status</code> parameter to see
 * whether an <code>Evaluation</code> is marked as <code>DELETED</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteEvaluationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteEvaluationResponse.Builder, DeleteEvaluationResponse> {
    private final String evaluationId;

    private DeleteEvaluationResponse(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the
     * value of the <code>EvaluationId</code> in the request.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical
     *         to the value of the <code>EvaluationId</code> in the request.
     */
    public String evaluationId() {
        return evaluationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((evaluationId() == null) ? 0 : evaluationId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEvaluationResponse)) {
            return false;
        }
        DeleteEvaluationResponse other = (DeleteEvaluationResponse) obj;
        if (other.evaluationId() == null ^ this.evaluationId() == null) {
            return false;
        }
        if (other.evaluationId() != null && !other.evaluationId().equals(this.evaluationId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (evaluationId() != null) {
            sb.append("EvaluationId: ").append(evaluationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.of(clazz.cast(evaluationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteEvaluationResponse> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to
         * the value of the <code>EvaluationId</code> in the request.
         * </p>
         * 
         * @param evaluationId
         *        A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be
         *        identical to the value of the <code>EvaluationId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEvaluationResponse model) {
            evaluationId(model.evaluationId);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public DeleteEvaluationResponse build() {
            return new DeleteEvaluationResponse(this);
        }
    }
}
