/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateBatchPredictionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateBatchPredictionRequest.Builder, CreateBatchPredictionRequest> {
    private final String batchPredictionId;

    private final String batchPredictionName;

    private final String mlModelId;

    private final String batchPredictionDataSourceId;

    private final String outputUri;

    private CreateBatchPredictionRequest(BuilderImpl builder) {
        this.batchPredictionId = builder.batchPredictionId;
        this.batchPredictionName = builder.batchPredictionName;
        this.mlModelId = builder.mlModelId;
        this.batchPredictionDataSourceId = builder.batchPredictionDataSourceId;
        this.outputUri = builder.outputUri;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.
     */
    public String batchPredictionId() {
        return batchPredictionId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can
     * only use the UTF-8 character set.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code>
     *         can only use the UTF-8 character set.
     */
    public String batchPredictionName() {
        return batchPredictionName;
    }

    /**
     * <p>
     * The ID of the <code>MLModel</code> that will generate predictions for the group of observations.
     * </p>
     * 
     * @return The ID of the <code>MLModel</code> that will generate predictions for the group of observations.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The ID of the <code>DataSource</code> that points to the group of observations to predict.
     * </p>
     * 
     * @return The ID of the <code>DataSource</code> that points to the group of observations to predict.
     */
    public String batchPredictionDataSourceId() {
        return batchPredictionDataSourceId;
    }

    /**
     * <p>
     * The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction
     * results. The following substrings are not allowed in the <code>s3 key</code> portion of the
     * <code>outputURI</code> field: ':', '//', '/./', '/../'.
     * </p>
     * <p>
     * Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set
     * permissions, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning
     * Developer Guide</a>.
     * </p>
     * 
     * @return The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch
     *         prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the
     *         <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
     *         <p>
     *         Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to
     *         set permissions, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine
     *         Learning Developer Guide</a>.
     */
    public String outputUri() {
        return outputUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((batchPredictionId() == null) ? 0 : batchPredictionId().hashCode());
        hashCode = 31 * hashCode + ((batchPredictionName() == null) ? 0 : batchPredictionName().hashCode());
        hashCode = 31 * hashCode + ((mlModelId() == null) ? 0 : mlModelId().hashCode());
        hashCode = 31 * hashCode + ((batchPredictionDataSourceId() == null) ? 0 : batchPredictionDataSourceId().hashCode());
        hashCode = 31 * hashCode + ((outputUri() == null) ? 0 : outputUri().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchPredictionRequest)) {
            return false;
        }
        CreateBatchPredictionRequest other = (CreateBatchPredictionRequest) obj;
        if (other.batchPredictionId() == null ^ this.batchPredictionId() == null) {
            return false;
        }
        if (other.batchPredictionId() != null && !other.batchPredictionId().equals(this.batchPredictionId())) {
            return false;
        }
        if (other.batchPredictionName() == null ^ this.batchPredictionName() == null) {
            return false;
        }
        if (other.batchPredictionName() != null && !other.batchPredictionName().equals(this.batchPredictionName())) {
            return false;
        }
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.batchPredictionDataSourceId() == null ^ this.batchPredictionDataSourceId() == null) {
            return false;
        }
        if (other.batchPredictionDataSourceId() != null
                && !other.batchPredictionDataSourceId().equals(this.batchPredictionDataSourceId())) {
            return false;
        }
        if (other.outputUri() == null ^ this.outputUri() == null) {
            return false;
        }
        if (other.outputUri() != null && !other.outputUri().equals(this.outputUri())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (batchPredictionId() != null) {
            sb.append("BatchPredictionId: ").append(batchPredictionId()).append(",");
        }
        if (batchPredictionName() != null) {
            sb.append("BatchPredictionName: ").append(batchPredictionName()).append(",");
        }
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (batchPredictionDataSourceId() != null) {
            sb.append("BatchPredictionDataSourceId: ").append(batchPredictionDataSourceId()).append(",");
        }
        if (outputUri() != null) {
            sb.append("OutputUri: ").append(outputUri()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.of(clazz.cast(batchPredictionId()));
        case "BatchPredictionName":
            return Optional.of(clazz.cast(batchPredictionName()));
        case "MLModelId":
            return Optional.of(clazz.cast(mlModelId()));
        case "BatchPredictionDataSourceId":
            return Optional.of(clazz.cast(batchPredictionDataSourceId()));
        case "OutputUri":
            return Optional.of(clazz.cast(outputUri()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateBatchPredictionRequest> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.
         * </p>
         * 
         * @param batchPredictionId
         *        A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);

        /**
         * <p>
         * A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can
         * only use the UTF-8 character set.
         * </p>
         * 
         * @param batchPredictionName
         *        A user-supplied name or description of the <code>BatchPrediction</code>.
         *        <code>BatchPredictionName</code> can only use the UTF-8 character set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionName(String batchPredictionName);

        /**
         * <p>
         * The ID of the <code>MLModel</code> that will generate predictions for the group of observations.
         * </p>
         * 
         * @param mlModelId
         *        The ID of the <code>MLModel</code> that will generate predictions for the group of observations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The ID of the <code>DataSource</code> that points to the group of observations to predict.
         * </p>
         * 
         * @param batchPredictionDataSourceId
         *        The ID of the <code>DataSource</code> that points to the group of observations to predict.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionDataSourceId(String batchPredictionDataSourceId);

        /**
         * <p>
         * The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch
         * prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the
         * <code>outputURI</code> field: ':', '//', '/./', '/../'.
         * </p>
         * <p>
         * Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set
         * permissions, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning
         * Developer Guide</a>.
         * </p>
         * 
         * @param outputUri
         *        The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch
         *        prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the
         *        <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
         *        <p>
         *        Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how
         *        to set permissions, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon
         *        Machine Learning Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUri(String outputUri);
    }

    static final class BuilderImpl implements Builder {
        private String batchPredictionId;

        private String batchPredictionName;

        private String mlModelId;

        private String batchPredictionDataSourceId;

        private String outputUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchPredictionRequest model) {
            batchPredictionId(model.batchPredictionId);
            batchPredictionName(model.batchPredictionName);
            mlModelId(model.mlModelId);
            batchPredictionDataSourceId(model.batchPredictionDataSourceId);
            outputUri(model.outputUri);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        public final String getBatchPredictionName() {
            return batchPredictionName;
        }

        @Override
        public final Builder batchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
            return this;
        }

        public final void setBatchPredictionName(String batchPredictionName) {
            this.batchPredictionName = batchPredictionName;
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getBatchPredictionDataSourceId() {
            return batchPredictionDataSourceId;
        }

        @Override
        public final Builder batchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
            return this;
        }

        public final void setBatchPredictionDataSourceId(String batchPredictionDataSourceId) {
            this.batchPredictionDataSourceId = batchPredictionDataSourceId;
        }

        public final String getOutputUri() {
            return outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public CreateBatchPredictionRequest build() {
            return new CreateBatchPredictionRequest(this);
        }
    }
}
