/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.machinelearning.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RDSDataSpec JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RDSDataSpecUnmarshaller implements Unmarshaller<RDSDataSpec, JsonUnmarshallerContext> {

    public RDSDataSpec unmarshall(JsonUnmarshallerContext context) throws Exception {
        RDSDataSpec.Builder rdsDataSpecBuilder = RDSDataSpec.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DatabaseInformation", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.databaseInformation(RDSDatabaseUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SelectSqlQuery", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.selectSqlQuery(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DatabaseCredentials", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.databaseCredentials(RDSDatabaseCredentialsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("S3StagingLocation", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.s3StagingLocation(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DataRearrangement", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.dataRearrangement(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DataSchema", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.dataSchema(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DataSchemaUri", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.dataSchemaUri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ResourceRole", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.resourceRole(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ServiceRole", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.serviceRole(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SubnetId", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.subnetId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SecurityGroupIds", targetDepth)) {
                    context.nextToken();
                    rdsDataSpecBuilder.securityGroupIds(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return rdsDataSpecBuilder.build();
    }

    private static final RDSDataSpecUnmarshaller INSTANCE = new RDSDataSpecUnmarshaller();

    public static RDSDataSpecUnmarshaller getInstance() {
        return INSTANCE;
    }
}
