/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateMLModelRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateMLModelRequest.Builder, UpdateMLModelRequest> {
    private final String mlModelId;

    private final String mlModelName;

    private final Float scoreThreshold;

    private UpdateMLModelRequest(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.mlModelName = builder.mlModelName;
        this.scoreThreshold = builder.scoreThreshold;
    }

    /**
     * <p>
     * The ID assigned to the <code>MLModel</code> during creation.
     * </p>
     * 
     * @return The ID assigned to the <code>MLModel</code> during creation.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>MLModel</code>.
     */
    public String mlModelName() {
        return mlModelName;
    }

    /**
     * <p>
     * The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary
     * between a positive prediction and a negative prediction.
     * </p>
     * <p>
     * Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the
     * <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive
     * a negative response from the <code>MLModel</code>, such as <code>false</code>.
     * </p>
     * 
     * @return The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the
     *         boundary between a positive prediction and a negative prediction.</p>
     *         <p>
     *         Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the
     *         <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code>
     *         receive a negative response from the <code>MLModel</code>, such as <code>false</code>.
     */
    public Float scoreThreshold() {
        return scoreThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mlModelId() == null) ? 0 : mlModelId().hashCode());
        hashCode = 31 * hashCode + ((mlModelName() == null) ? 0 : mlModelName().hashCode());
        hashCode = 31 * hashCode + ((scoreThreshold() == null) ? 0 : scoreThreshold().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMLModelRequest)) {
            return false;
        }
        UpdateMLModelRequest other = (UpdateMLModelRequest) obj;
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.mlModelName() == null ^ this.mlModelName() == null) {
            return false;
        }
        if (other.mlModelName() != null && !other.mlModelName().equals(this.mlModelName())) {
            return false;
        }
        if (other.scoreThreshold() == null ^ this.scoreThreshold() == null) {
            return false;
        }
        if (other.scoreThreshold() != null && !other.scoreThreshold().equals(this.scoreThreshold())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (mlModelName() != null) {
            sb.append("MLModelName: ").append(mlModelName()).append(",");
        }
        if (scoreThreshold() != null) {
            sb.append("ScoreThreshold: ").append(scoreThreshold()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateMLModelRequest> {
        /**
         * <p>
         * The ID assigned to the <code>MLModel</code> during creation.
         * </p>
         * 
         * @param mlModelId
         *        The ID assigned to the <code>MLModel</code> during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * A user-supplied name or description of the <code>MLModel</code>.
         * </p>
         * 
         * @param mlModelName
         *        A user-supplied name or description of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelName(String mlModelName);

        /**
         * <p>
         * The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary
         * between a positive prediction and a negative prediction.
         * </p>
         * <p>
         * Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the
         * <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code>
         * receive a negative response from the <code>MLModel</code>, such as <code>false</code>.
         * </p>
         * 
         * @param scoreThreshold
         *        The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the
         *        boundary between a positive prediction and a negative prediction.</p>
         *        <p>
         *        Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from
         *        the <code>MLModel</code>, such as <code>true</code>. Output values less than the
         *        <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThreshold(Float scoreThreshold);
    }

    private static final class BuilderImpl implements Builder {
        private String mlModelId;

        private String mlModelName;

        private Float scoreThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMLModelRequest model) {
            setMLModelId(model.mlModelId);
            setMLModelName(model.mlModelName);
            setScoreThreshold(model.scoreThreshold);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getMLModelName() {
            return mlModelName;
        }

        @Override
        public final Builder mlModelName(String mlModelName) {
            this.mlModelName = mlModelName;
            return this;
        }

        public final void setMLModelName(String mlModelName) {
            this.mlModelName = mlModelName;
        }

        public final Float getScoreThreshold() {
            return scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        @Override
        public UpdateMLModelRequest build() {
            return new UpdateMLModelRequest(this);
        }
    }
}
