/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import static software.amazon.awssdk.util.StringUtils.isNullOrEmpty;

import java.util.stream.Stream;
import javax.annotation.Generated;

/**
 * <p>
 * A list of the variables to use in searching or filtering <code>Evaluation</code>.
 * </p>
 * <ul>
 * <li> <code>CreatedAt</code> - Sets the search criteria to <code>Evaluation</code> creation date.</li>
 * <li> <code>Status</code> - Sets the search criteria to <code>Evaluation</code> status.</li>
 * <li> <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code> <b> </b>
 * <code>Name</code>.</li>
 * <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked an evaluation.</li>
 * <li> <code>MLModelId</code> - Sets the search criteria to the <code>Predictor</code> that was evaluated.</li>
 * <li> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in evaluation.</li>
 * <li> <code>DataUri</code> - Sets the search criteria to the data file(s) used in evaluation. The URL can identify
 * either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum EvaluationFilterVariable {
    CreatedAt("CreatedAt"),

    LastUpdatedAt("LastUpdatedAt"),

    Status("Status"),

    Name("Name"),

    IAMUser("IAMUser"),

    MLModelId("MLModelId"),

    DataSourceId("DataSourceId"),

    DataURI("DataURI");

    private final String value;

    private EvaluationFilterVariable(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return EvaluationFilterVariable corresponding to the value
     */
    public static EvaluationFilterVariable fromValue(String value) {
        if (isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(EvaluationFilterVariable.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}
