/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMLModelsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeMLModelsRequest.Builder, DescribeMLModelsRequest> {
    private final String filterVariable;

    private final String eq;

    private final String gt;

    private final String lt;

    private final String ge;

    private final String le;

    private final String ne;

    private final String prefix;

    private final String sortOrder;

    private final String nextToken;

    private final Integer limit;

    private DescribeMLModelsRequest(BuilderImpl builder) {
        this.filterVariable = builder.filterVariable;
        this.eq = builder.eq;
        this.gt = builder.gt;
        this.lt = builder.lt;
        this.ge = builder.ge;
        this.le = builder.le;
        this.ne = builder.ne;
        this.prefix = builder.prefix;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * Use one of the following variables to filter a list of <code>MLModel</code>:
     * </p>
     * <ul>
     * <li> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</li>
     * <li> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</li>
     * <li> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code><b> </b>
     * <code>Name</code>.</li>
     * <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code>
     * creation.</li>
     * <li> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one
     * or more <code>MLModel</code>.</li>
     * <li> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint
     * status.</li>
     * <li> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or
     * multi-class.</li>
     * <li> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</li>
     * <li> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a
     * <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket
     * or directory.</li>
     * </ul>
     * 
     * @return Use one of the following variables to filter a list of <code>MLModel</code>:</p>
     *         <ul>
     *         <li> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</li>
     *         <li> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</li>
     *         <li> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code><b> </b>
     *         <code>Name</code>.</li>
     *         <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the
     *         <code>MLModel</code> creation.</li>
     *         <li> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to
     *         train one or more <code>MLModel</code>.</li>
     *         <li> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time
     *         endpoint status.</li>
     *         <li> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression,
     *         or multi-class.</li>
     *         <li> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code>
     *         uses.</li>
     *         <li> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a
     *         <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3)
     *         bucket or directory.</li>
     * @see MLModelFilterVariable
     */
    public String filterVariable() {
        return filterVariable;
    }

    /**
     * <p>
     * The equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that exactly
     * match the value specified with <code>EQ</code>.
     * </p>
     * 
     * @return The equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that
     *         exactly match the value specified with <code>EQ</code>.
     */
    public String eq() {
        return eq;
    }

    /**
     * <p>
     * The greater than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are
     * greater than the value specified with <code>GT</code>.
     * </p>
     * 
     * @return The greater than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values
     *         that are greater than the value specified with <code>GT</code>.
     */
    public String gt() {
        return gt;
    }

    /**
     * <p>
     * The less than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are
     * less than the value specified with <code>LT</code>.
     * </p>
     * 
     * @return The less than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values
     *         that are less than the value specified with <code>LT</code>.
     */
    public String lt() {
        return lt;
    }

    /**
     * <p>
     * The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code>
     * values that are greater than or equal to the value specified with <code>GE</code>.
     * </p>
     * 
     * @return The greater than or equal to operator. The <code>MLModel</code> results will have
     *         <code>FilterVariable</code> values that are greater than or equal to the value specified with
     *         <code>GE</code>.
     */
    public String ge() {
        return ge;
    }

    /**
     * <p>
     * The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values
     * that are less than or equal to the value specified with <code>LE</code>.
     * </p>
     * 
     * @return The less than or equal to operator. The <code>MLModel</code> results will have
     *         <code>FilterVariable</code> values that are less than or equal to the value specified with
     *         <code>LE</code>.
     */
    public String le() {
        return le;
    }

    /**
     * <p>
     * The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not
     * equal to the value specified with <code>NE</code>.
     * </p>
     * 
     * @return The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values
     *         not equal to the value specified with <code>NE</code>.
     */
    public String ne() {
        return ne;
    }

    /**
     * <p>
     * A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.
     * </p>
     * <p>
     * For example, an <code>MLModel</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>.
     * To search for this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of
     * the following strings for the <code>Prefix</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 2014-09
     * </p>
     * </li>
     * <li>
     * <p>
     * 2014-09-09
     * </p>
     * </li>
     * <li>
     * <p>
     * 2014-09-09-Holiday
     * </p>
     * </li>
     * </ul>
     * 
     * @return A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
     *         <p>
     *         For example, an <code>MLModel</code> could have the <code>Name</code>
     *         <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>MLModel</code>, select
     *         <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
     *         <code>Prefix</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         2014-09
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2014-09-09
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2014-09-09-Holiday
     *         </p>
     *         </li>
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.
     * </p>
     * <ul>
     * <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li>
     * <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li>
     * </ul>
     * <p>
     * Results are sorted by <code>FilterVariable</code>.
     * </p>
     * 
     * @return A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
     *         <ul>
     *         <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li>
     *         <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li>
     *         </ul>
     *         <p>
     *         Results are sorted by <code>FilterVariable</code>.
     * @see SortOrder
     */
    public String sortOrder() {
        return sortOrder;
    }

    /**
     * <p>
     * The ID of the page in the paginated results.
     * </p>
     * 
     * @return The ID of the page in the paginated results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of pages of information to include in the result. The range of acceptable values is <code>1</code>
     * through <code>100</code>. The default value is <code>100</code>.
     * </p>
     * 
     * @return The number of pages of information to include in the result. The range of acceptable values is
     *         <code>1</code> through <code>100</code>. The default value is <code>100</code>.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filterVariable() == null) ? 0 : filterVariable().hashCode());
        hashCode = 31 * hashCode + ((eq() == null) ? 0 : eq().hashCode());
        hashCode = 31 * hashCode + ((gt() == null) ? 0 : gt().hashCode());
        hashCode = 31 * hashCode + ((lt() == null) ? 0 : lt().hashCode());
        hashCode = 31 * hashCode + ((ge() == null) ? 0 : ge().hashCode());
        hashCode = 31 * hashCode + ((le() == null) ? 0 : le().hashCode());
        hashCode = 31 * hashCode + ((ne() == null) ? 0 : ne().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((sortOrder() == null) ? 0 : sortOrder().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMLModelsRequest)) {
            return false;
        }
        DescribeMLModelsRequest other = (DescribeMLModelsRequest) obj;
        if (other.filterVariable() == null ^ this.filterVariable() == null) {
            return false;
        }
        if (other.filterVariable() != null && !other.filterVariable().equals(this.filterVariable())) {
            return false;
        }
        if (other.eq() == null ^ this.eq() == null) {
            return false;
        }
        if (other.eq() != null && !other.eq().equals(this.eq())) {
            return false;
        }
        if (other.gt() == null ^ this.gt() == null) {
            return false;
        }
        if (other.gt() != null && !other.gt().equals(this.gt())) {
            return false;
        }
        if (other.lt() == null ^ this.lt() == null) {
            return false;
        }
        if (other.lt() != null && !other.lt().equals(this.lt())) {
            return false;
        }
        if (other.ge() == null ^ this.ge() == null) {
            return false;
        }
        if (other.ge() != null && !other.ge().equals(this.ge())) {
            return false;
        }
        if (other.le() == null ^ this.le() == null) {
            return false;
        }
        if (other.le() != null && !other.le().equals(this.le())) {
            return false;
        }
        if (other.ne() == null ^ this.ne() == null) {
            return false;
        }
        if (other.ne() != null && !other.ne().equals(this.ne())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.sortOrder() == null ^ this.sortOrder() == null) {
            return false;
        }
        if (other.sortOrder() != null && !other.sortOrder().equals(this.sortOrder())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filterVariable() != null) {
            sb.append("FilterVariable: ").append(filterVariable()).append(",");
        }
        if (eq() != null) {
            sb.append("EQ: ").append(eq()).append(",");
        }
        if (gt() != null) {
            sb.append("GT: ").append(gt()).append(",");
        }
        if (lt() != null) {
            sb.append("LT: ").append(lt()).append(",");
        }
        if (ge() != null) {
            sb.append("GE: ").append(ge()).append(",");
        }
        if (le() != null) {
            sb.append("LE: ").append(le()).append(",");
        }
        if (ne() != null) {
            sb.append("NE: ").append(ne()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (sortOrder() != null) {
            sb.append("SortOrder: ").append(sortOrder()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMLModelsRequest> {
        /**
         * <p>
         * Use one of the following variables to filter a list of <code>MLModel</code>:
         * </p>
         * <ul>
         * <li> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</li>
         * <li> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</li>
         * <li> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code><b> </b>
         * <code>Name</code>.</li>
         * <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code>
         * creation.</li>
         * <li> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train
         * one or more <code>MLModel</code>.</li>
         * <li> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time
         * endpoint status.</li>
         * <li> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or
         * multi-class.</li>
         * <li> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</li>
         * <li> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a
         * <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3)
         * bucket or directory.</li>
         * </ul>
         * 
         * @param filterVariable
         *        Use one of the following variables to filter a list of <code>MLModel</code>:</p>
         *        <ul>
         *        <li> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</li>
         *        <li> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</li>
         *        <li> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code><b> </b>
         *        <code>Name</code>.</li>
         *        <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the
         *        <code>MLModel</code> creation.</li>
         *        <li> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used
         *        to train one or more <code>MLModel</code>.</li>
         *        <li> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code>
         *        real-time endpoint status.</li>
         *        <li> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary,
         *        regression, or multi-class.</li>
         *        <li> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code>
         *        uses.</li>
         *        <li> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a
         *        <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon
         *        S3) bucket or directory.</li>
         * @see MLModelFilterVariable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelFilterVariable
         */
        Builder filterVariable(String filterVariable);

        /**
         * <p>
         * Use one of the following variables to filter a list of <code>MLModel</code>:
         * </p>
         * <ul>
         * <li> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</li>
         * <li> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</li>
         * <li> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code><b> </b>
         * <code>Name</code>.</li>
         * <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code>
         * creation.</li>
         * <li> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train
         * one or more <code>MLModel</code>.</li>
         * <li> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time
         * endpoint status.</li>
         * <li> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or
         * multi-class.</li>
         * <li> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</li>
         * <li> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a
         * <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3)
         * bucket or directory.</li>
         * </ul>
         * 
         * @param filterVariable
         *        Use one of the following variables to filter a list of <code>MLModel</code>:</p>
         *        <ul>
         *        <li> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</li>
         *        <li> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</li>
         *        <li> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code><b> </b>
         *        <code>Name</code>.</li>
         *        <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the
         *        <code>MLModel</code> creation.</li>
         *        <li> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used
         *        to train one or more <code>MLModel</code>.</li>
         *        <li> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code>
         *        real-time endpoint status.</li>
         *        <li> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary,
         *        regression, or multi-class.</li>
         *        <li> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code>
         *        uses.</li>
         *        <li> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a
         *        <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon
         *        S3) bucket or directory.</li>
         * @see MLModelFilterVariable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelFilterVariable
         */
        Builder filterVariable(MLModelFilterVariable filterVariable);

        /**
         * <p>
         * The equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that
         * exactly match the value specified with <code>EQ</code>.
         * </p>
         * 
         * @param eq
         *        The equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values
         *        that exactly match the value specified with <code>EQ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(String eq);

        /**
         * <p>
         * The greater than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that
         * are greater than the value specified with <code>GT</code>.
         * </p>
         * 
         * @param gt
         *        The greater than operator. The <code>MLModel</code> results will have <code>FilterVariable</code>
         *        values that are greater than the value specified with <code>GT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gt(String gt);

        /**
         * <p>
         * The less than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that
         * are less than the value specified with <code>LT</code>.
         * </p>
         * 
         * @param lt
         *        The less than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values
         *        that are less than the value specified with <code>LT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lt(String lt);

        /**
         * <p>
         * The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code>
         * values that are greater than or equal to the value specified with <code>GE</code>.
         * </p>
         * 
         * @param ge
         *        The greater than or equal to operator. The <code>MLModel</code> results will have
         *        <code>FilterVariable</code> values that are greater than or equal to the value specified with
         *        <code>GE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ge(String ge);

        /**
         * <p>
         * The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code>
         * values that are less than or equal to the value specified with <code>LE</code>.
         * </p>
         * 
         * @param le
         *        The less than or equal to operator. The <code>MLModel</code> results will have
         *        <code>FilterVariable</code> values that are less than or equal to the value specified with
         *        <code>LE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder le(String le);

        /**
         * <p>
         * The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not
         * equal to the value specified with <code>NE</code>.
         * </p>
         * 
         * @param ne
         *        The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code>
         *        values not equal to the value specified with <code>NE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ne(String ne);

        /**
         * <p>
         * A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.
         * </p>
         * <p>
         * For example, an <code>MLModel</code> could have the <code>Name</code>
         * <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>MLModel</code>, select <code>Name</code>
         * for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 2014-09
         * </p>
         * </li>
         * <li>
         * <p>
         * 2014-09-09
         * </p>
         * </li>
         * <li>
         * <p>
         * 2014-09-09-Holiday
         * </p>
         * </li>
         * </ul>
         * 
         * @param prefix
         *        A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>
         *        .</p>
         *        <p>
         *        For example, an <code>MLModel</code> could have the <code>Name</code>
         *        <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>MLModel</code>, select
         *        <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
         *        <code>Prefix</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        2014-09
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2014-09-09
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2014-09-09-Holiday
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.
         * </p>
         * <ul>
         * <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li>
         * <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li>
         * </ul>
         * <p>
         * Results are sorted by <code>FilterVariable</code>.
         * </p>
         * 
         * @param sortOrder
         *        A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
         *        <ul>
         *        <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li>
         *        <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li>
         *        </ul>
         *        <p>
         *        Results are sorted by <code>FilterVariable</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.
         * </p>
         * <ul>
         * <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li>
         * <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li>
         * </ul>
         * <p>
         * Results are sorted by <code>FilterVariable</code>.
         * </p>
         * 
         * @param sortOrder
         *        A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
         *        <ul>
         *        <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li>
         *        <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li>
         *        </ul>
         *        <p>
         *        Results are sorted by <code>FilterVariable</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The ID of the page in the paginated results.
         * </p>
         * 
         * @param nextToken
         *        The ID of the page in the paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of pages of information to include in the result. The range of acceptable values is <code>1</code>
         * through <code>100</code>. The default value is <code>100</code>.
         * </p>
         * 
         * @param limit
         *        The number of pages of information to include in the result. The range of acceptable values is
         *        <code>1</code> through <code>100</code>. The default value is <code>100</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);
    }

    private static final class BuilderImpl implements Builder {
        private String filterVariable;

        private String eq;

        private String gt;

        private String lt;

        private String ge;

        private String le;

        private String ne;

        private String prefix;

        private String sortOrder;

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMLModelsRequest model) {
            setFilterVariable(model.filterVariable);
            setEQ(model.eq);
            setGT(model.gt);
            setLT(model.lt);
            setGE(model.ge);
            setLE(model.le);
            setNE(model.ne);
            setPrefix(model.prefix);
            setSortOrder(model.sortOrder);
            setNextToken(model.nextToken);
            setLimit(model.limit);
        }

        public final String getFilterVariable() {
            return filterVariable;
        }

        @Override
        public final Builder filterVariable(String filterVariable) {
            this.filterVariable = filterVariable;
            return this;
        }

        @Override
        public final Builder filterVariable(MLModelFilterVariable filterVariable) {
            this.filterVariable(filterVariable.toString());
            return this;
        }

        public final void setFilterVariable(String filterVariable) {
            this.filterVariable = filterVariable;
        }

        public final String getEQ() {
            return eq;
        }

        @Override
        public final Builder eq(String eq) {
            this.eq = eq;
            return this;
        }

        public final void setEQ(String eq) {
            this.eq = eq;
        }

        public final String getGT() {
            return gt;
        }

        @Override
        public final Builder gt(String gt) {
            this.gt = gt;
            return this;
        }

        public final void setGT(String gt) {
            this.gt = gt;
        }

        public final String getLT() {
            return lt;
        }

        @Override
        public final Builder lt(String lt) {
            this.lt = lt;
            return this;
        }

        public final void setLT(String lt) {
            this.lt = lt;
        }

        public final String getGE() {
            return ge;
        }

        @Override
        public final Builder ge(String ge) {
            this.ge = ge;
            return this;
        }

        public final void setGE(String ge) {
            this.ge = ge;
        }

        public final String getLE() {
            return le;
        }

        @Override
        public final Builder le(String le) {
            this.le = le;
            return this;
        }

        public final void setLE(String le) {
            this.le = le;
        }

        public final String getNE() {
            return ne;
        }

        @Override
        public final Builder ne(String ne) {
            this.ne = ne;
            return this;
        }

        public final void setNE(String ne) {
            this.ne = ne;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public DescribeMLModelsRequest build() {
            return new DescribeMLModelsRequest(this);
        }
    }
}
