/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DeleteEvaluation</code> operation. The output indicates that Amazon Machine Learning
 * (Amazon ML) received the request.
 * </p>
 * <p>
 * You can use the <code>GetEvaluation</code> operation and check the value of the <code>Status</code> parameter to see
 * whether an <code>Evaluation</code> is marked as <code>DELETED</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEvaluationResponse extends MachineLearningResponse implements
        ToCopyableBuilder<DeleteEvaluationResponse.Builder, DeleteEvaluationResponse> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteEvaluationResponse::evaluationId)).setter(setter(Builder::evaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD));

    private final String evaluationId;

    private DeleteEvaluationResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the
     * value of the <code>EvaluationId</code> in the request.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical
     *         to the value of the <code>EvaluationId</code> in the request.
     */
    public String evaluationId() {
        return evaluationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEvaluationResponse)) {
            return false;
        }
        DeleteEvaluationResponse other = (DeleteEvaluationResponse) obj;
        return Objects.equals(evaluationId(), other.evaluationId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteEvaluationResponse").add("EvaluationId", evaluationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.ofNullable(clazz.cast(evaluationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEvaluationResponse, T> g) {
        return obj -> g.apply((DeleteEvaluationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEvaluationResponse> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to
         * the value of the <code>EvaluationId</code> in the request.
         * </p>
         * 
         * @param evaluationId
         *        A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be
         *        identical to the value of the <code>EvaluationId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String evaluationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEvaluationResponse model) {
            super(model);
            evaluationId(model.evaluationId);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public DeleteEvaluationResponse build() {
            return new DeleteEvaluationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
