/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.machinelearning.model.S3DataSpec;

public class S3DataSpecUnmarshaller
implements Unmarshaller<S3DataSpec, JsonUnmarshallerContext> {
    private static final S3DataSpecUnmarshaller INSTANCE = new S3DataSpecUnmarshaller();

    public S3DataSpec unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3DataSpec.Builder s3DataSpecBuilder = S3DataSpec.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DataLocationS3", targetDepth)) {
                    context.nextToken();
                    s3DataSpecBuilder.dataLocationS3((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataRearrangement", targetDepth)) {
                    context.nextToken();
                    s3DataSpecBuilder.dataRearrangement((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSchema", targetDepth)) {
                    context.nextToken();
                    s3DataSpecBuilder.dataSchema((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSchemaLocationS3", targetDepth)) {
                    context.nextToken();
                    s3DataSpecBuilder.dataSchemaLocationS3((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3DataSpec)s3DataSpecBuilder.build();
    }

    public static S3DataSpecUnmarshaller getInstance() {
        return INSTANCE;
    }
}

