/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RDSDatabaseMarshaller {
    private static final MarshallingInfo<String> INSTANCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final RDSDatabaseMarshaller INSTANCE = new RDSDatabaseMarshaller();

    private RDSDatabaseMarshaller() {
    }

    public static RDSDatabaseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RDSDatabase rdsDatabase, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rdsDatabase, (String)"rdsDatabase");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rdsDatabase.instanceIdentifier(), INSTANCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)rdsDatabase.databaseName(), DATABASENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

