/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDataSourceFromS3RequestModelMarshaller {
    private static final MarshallingInfo<String> DATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceId").isBinary(false).build();
    private static final MarshallingInfo<String> DATASOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DATASPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSpec").isBinary(false).build();
    private static final MarshallingInfo<Boolean> COMPUTESTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeStatistics").isBinary(false).build();
    private static final CreateDataSourceFromS3RequestModelMarshaller INSTANCE = new CreateDataSourceFromS3RequestModelMarshaller();

    private CreateDataSourceFromS3RequestModelMarshaller() {
    }

    public static CreateDataSourceFromS3RequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDataSourceFromS3Request createDataSourceFromS3Request, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDataSourceFromS3Request), (String)"createDataSourceFromS3Request");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDataSourceFromS3Request.dataSourceId(), DATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)createDataSourceFromS3Request.dataSourceName(), DATASOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)createDataSourceFromS3Request.dataSpec(), DATASPEC_BINDING);
            protocolMarshaller.marshall((Object)createDataSourceFromS3Request.computeStatistics(), COMPUTESTATISTICS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

