/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RDSDatabaseCredentialsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSDatabaseCredentials
implements StructuredPojo,
ToCopyableBuilder<Builder, RDSDatabaseCredentials> {
    private final String username;
    private final String password;

    private RDSDatabaseCredentials(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDatabaseCredentials)) {
            return false;
        }
        RDSDatabaseCredentials other = (RDSDatabaseCredentials)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password());
    }

    public String toString() {
        return ToString.builder((String)"RDSDatabaseCredentials").add("Username", (Object)this.username()).add("Password", (Object)this.password()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDatabaseCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDatabaseCredentials model) {
            this.username(model.username);
            this.password(model.password);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public RDSDatabaseCredentials build() {
            return new RDSDatabaseCredentials(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RDSDatabaseCredentials> {
        public Builder username(String var1);

        public Builder password(String var1);
    }
}

