/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MLModelType {
    REGRESSION("REGRESSION"),
    BINARY("BINARY"),
    MULTICLASS("MULTICLASS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MLModelType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MLModelType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MLModelType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MLModelType> knownValues() {
        return Stream.of(MLModelType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

