/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.model.RDSDataSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceFromRdsRequest
extends MachineLearningRequest
implements ToCopyableBuilder<Builder, CreateDataSourceFromRdsRequest> {
    private final String dataSourceId;
    private final String dataSourceName;
    private final RDSDataSpec rdsData;
    private final String roleARN;
    private final Boolean computeStatistics;

    private CreateDataSourceFromRdsRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.rdsData = builder.rdsData;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public RDSDataSpec rdsData() {
        return this.rdsData;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Boolean computeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsData());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeStatistics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRdsRequest)) {
            return false;
        }
        CreateDataSourceFromRdsRequest other = (CreateDataSourceFromRdsRequest)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.rdsData(), other.rdsData()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.computeStatistics(), other.computeStatistics());
    }

    public String toString() {
        return ToString.builder((String)"CreateDataSourceFromRdsRequest").add("DataSourceId", (Object)this.dataSourceId()).add("DataSourceName", (Object)this.dataSourceName()).add("RDSData", (Object)this.rdsData()).add("RoleARN", (Object)this.roleARN()).add("ComputeStatistics", (Object)this.computeStatistics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "RDSData": {
                return Optional.ofNullable(clazz.cast(this.rdsData()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "ComputeStatistics": {
                return Optional.ofNullable(clazz.cast(this.computeStatistics()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MachineLearningRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String dataSourceName;
        private RDSDataSpec rdsData;
        private String roleARN;
        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRdsRequest model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
            this.dataSourceName(model.dataSourceName);
            this.rdsData(model.rdsData);
            this.roleARN(model.roleARN);
            this.computeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final RDSDataSpec.Builder getRDSData() {
            return this.rdsData != null ? this.rdsData.toBuilder() : null;
        }

        @Override
        public final Builder rdsData(RDSDataSpec rdsData) {
            this.rdsData = rdsData;
            return this;
        }

        public final void setRDSData(RDSDataSpec.BuilderImpl rdsData) {
            this.rdsData = rdsData != null ? rdsData.build() : null;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return this.computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceFromRdsRequest build() {
            return new CreateDataSourceFromRdsRequest(this);
        }
    }

    public static interface Builder
    extends MachineLearningRequest.Builder,
    CopyableBuilder<Builder, CreateDataSourceFromRdsRequest> {
        public Builder dataSourceId(String var1);

        public Builder dataSourceName(String var1);

        public Builder rdsData(RDSDataSpec var1);

        default public Builder rdsData(Consumer<RDSDataSpec.Builder> rdsData) {
            return this.rdsData((RDSDataSpec)((RDSDataSpec.Builder)RDSDataSpec.builder().applyMutation(rdsData)).build());
        }

        public Builder roleARN(String var1);

        public Builder computeStatistics(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

