/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.S3DataSpec;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link S3DataSpec} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class S3DataSpecMarshaller {
    private static final MarshallingInfo<String> DATALOCATIONS3_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataLocationS3").isBinary(false).build();

    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").isBinary(false).build();

    private static final MarshallingInfo<String> DATASCHEMA_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchema").isBinary(false).build();

    private static final MarshallingInfo<String> DATASCHEMALOCATIONS3_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchemaLocationS3").isBinary(false).build();

    private static final S3DataSpecMarshaller INSTANCE = new S3DataSpecMarshaller();

    private S3DataSpecMarshaller() {
    }

    public static S3DataSpecMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(S3DataSpec s3DataSpec, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(s3DataSpec, "s3DataSpec");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(s3DataSpec.dataLocationS3(), DATALOCATIONS3_BINDING);
            protocolMarshaller.marshall(s3DataSpec.dataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall(s3DataSpec.dataSchema(), DATASCHEMA_BINDING);
            protocolMarshaller.marshall(s3DataSpec.dataSchemaLocationS3(), DATASCHEMALOCATIONS3_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
