/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>UpdateMLModel</code> operation.
 * </p>
 * <p>
 * You can see the updated content by using the <code>GetMLModel</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMlModelResponse extends MachineLearningResponse implements
        ToCopyableBuilder<UpdateMlModelResponse.Builder, UpdateMlModelResponse> {
    private final String mlModelId;

    private UpdateMlModelResponse(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
    }

    /**
     * <p>
     * The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the value of the
     * <code>MLModelID</code> in the request.
     * </p>
     * 
     * @return The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the value
     *         of the <code>MLModelID</code> in the request.
     */
    public String mlModelId() {
        return mlModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMlModelResponse)) {
            return false;
        }
        UpdateMlModelResponse other = (UpdateMlModelResponse) obj;
        return Objects.equals(mlModelId(), other.mlModelId());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateMlModelResponse").add("MLModelId", mlModelId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, UpdateMlModelResponse> {
        /**
         * <p>
         * The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the value of
         * the <code>MLModelID</code> in the request.
         * </p>
         * 
         * @param mlModelId
         *        The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the
         *        value of the <code>MLModelID</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String mlModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMlModelResponse model) {
            super(model);
            mlModelId(model.mlModelId);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        @Override
        public UpdateMlModelResponse build() {
            return new UpdateMlModelResponse(this);
        }
    }
}
