/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.MLModel;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MLModel} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MLModelMarshaller {
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").isBinary(false).build();

    private static final MarshallingInfo<String> TRAININGDATASOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingDataSourceId").isBinary(false).build();

    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<Long> SIZEINBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ENDPOINTINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointInfo")
            .isBinary(false).build();

    private static final MarshallingInfo<Map> TRAININGPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingParameters").isBinary(false).build();

    private static final MarshallingInfo<String> INPUTDATALOCATIONS3_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataLocationS3").isBinary(false).build();

    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Algorithm").isBinary(false).build();

    private static final MarshallingInfo<String> MLMODELTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelType").isBinary(false).build();

    private static final MarshallingInfo<Float> SCORETHRESHOLD_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScoreThreshold").isBinary(false).build();

    private static final MarshallingInfo<Instant> SCORETHRESHOLDLASTUPDATEDAT_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ScoreThresholdLastUpdatedAt").isBinary(false).build();

    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();

    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> FINISHEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").isBinary(false).build();

    private static final MLModelMarshaller INSTANCE = new MLModelMarshaller();

    private MLModelMarshaller() {
    }

    public static MLModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MLModel mlModel, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(mlModel, "mlModel");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(mlModel.mlModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall(mlModel.trainingDataSourceId(), TRAININGDATASOURCEID_BINDING);
            protocolMarshaller.marshall(mlModel.createdByIamUser(), CREATEDBYIAMUSER_BINDING);
            protocolMarshaller.marshall(mlModel.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(mlModel.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(mlModel.name(), NAME_BINDING);
            protocolMarshaller.marshall(mlModel.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(mlModel.sizeInBytes(), SIZEINBYTES_BINDING);
            protocolMarshaller.marshall(mlModel.endpointInfo(), ENDPOINTINFO_BINDING);
            protocolMarshaller.marshall(mlModel.trainingParameters(), TRAININGPARAMETERS_BINDING);
            protocolMarshaller.marshall(mlModel.inputDataLocationS3(), INPUTDATALOCATIONS3_BINDING);
            protocolMarshaller.marshall(mlModel.algorithmAsString(), ALGORITHM_BINDING);
            protocolMarshaller.marshall(mlModel.mlModelTypeAsString(), MLMODELTYPE_BINDING);
            protocolMarshaller.marshall(mlModel.scoreThreshold(), SCORETHRESHOLD_BINDING);
            protocolMarshaller.marshall(mlModel.scoreThresholdLastUpdatedAt(), SCORETHRESHOLDLASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(mlModel.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall(mlModel.computeTime(), COMPUTETIME_BINDING);
            protocolMarshaller.marshall(mlModel.finishedAt(), FINISHEDAT_BINDING);
            protocolMarshaller.marshall(mlModel.startedAt(), STARTEDAT_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
