/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBatchPredictionRequest extends MachineLearningRequest implements
        ToCopyableBuilder<GetBatchPredictionRequest.Builder, GetBatchPredictionRequest> {
    private final String batchPredictionId;

    private GetBatchPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.batchPredictionId = builder.batchPredictionId;
    }

    /**
     * <p>
     * An ID assigned to the <code>BatchPrediction</code> at creation.
     * </p>
     * 
     * @return An ID assigned to the <code>BatchPrediction</code> at creation.
     */
    public String batchPredictionId() {
        return batchPredictionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBatchPredictionRequest)) {
            return false;
        }
        GetBatchPredictionRequest other = (GetBatchPredictionRequest) obj;
        return Objects.equals(batchPredictionId(), other.batchPredictionId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBatchPredictionRequest").add("BatchPredictionId", batchPredictionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.ofNullable(clazz.cast(batchPredictionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningRequest.Builder, CopyableBuilder<Builder, GetBatchPredictionRequest> {
        /**
         * <p>
         * An ID assigned to the <code>BatchPrediction</code> at creation.
         * </p>
         * 
         * @param batchPredictionId
         *        An ID assigned to the <code>BatchPrediction</code> at creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String batchPredictionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBatchPredictionRequest model) {
            super(model);
            batchPredictionId(model.batchPredictionId);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBatchPredictionRequest build() {
            return new GetBatchPredictionRequest(this);
        }
    }
}
