/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.Prediction;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Prediction} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class PredictionMarshaller {
    private static final MarshallingInfo<String> PREDICTEDLABEL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predictedLabel").isBinary(false).build();

    private static final MarshallingInfo<Float> PREDICTEDVALUE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predictedValue").isBinary(false).build();

    private static final MarshallingInfo<Map> PREDICTEDSCORES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("predictedScores").isBinary(false).build();

    private static final MarshallingInfo<Map> DETAILS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("details").isBinary(false).build();

    private static final PredictionMarshaller INSTANCE = new PredictionMarshaller();

    private PredictionMarshaller() {
    }

    public static PredictionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Prediction prediction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(prediction, "prediction");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(prediction.predictedLabel(), PREDICTEDLABEL_BINDING);
            protocolMarshaller.marshall(prediction.predictedValue(), PREDICTEDVALUE_BINDING);
            protocolMarshaller.marshall(prediction.predictedScores(), PREDICTEDSCORES_BINDING);
            protocolMarshaller.marshall(prediction.detailsAsStrings(), DETAILS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
