/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DescribeBatchPredictionsRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DescribeBatchPredictionsRequestModelMarshaller {
    private static final MarshallingInfo<String> FILTERVARIABLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FilterVariable").isBinary(false).build();

    private static final MarshallingInfo<String> EQ_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EQ").isBinary(false).build();

    private static final MarshallingInfo<String> GT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GT").isBinary(false).build();

    private static final MarshallingInfo<String> LT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LT").isBinary(false).build();

    private static final MarshallingInfo<String> GE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GE").isBinary(false).build();

    private static final MarshallingInfo<String> LE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LE").isBinary(false).build();

    private static final MarshallingInfo<String> NE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NE").isBinary(false).build();

    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Prefix").isBinary(false).build();

    private static final MarshallingInfo<String> SORTORDER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortOrder").isBinary(false).build();

    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();

    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();

    private static final DescribeBatchPredictionsRequestModelMarshaller INSTANCE = new DescribeBatchPredictionsRequestModelMarshaller();

    private DescribeBatchPredictionsRequestModelMarshaller() {
    }

    public static DescribeBatchPredictionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DescribeBatchPredictionsRequest describeBatchPredictionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(describeBatchPredictionsRequest, "describeBatchPredictionsRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(describeBatchPredictionsRequest.filterVariableAsString(), FILTERVARIABLE_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.eq(), EQ_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.gt(), GT_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.lt(), LT_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.ge(), GE_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.le(), LE_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.ne(), NE_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.prefix(), PREFIX_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.sortOrderAsString(), SORTORDER_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall(describeBatchPredictionsRequest.limit(), LIMIT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
