/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetEvaluation</code> operation and describes an <code>Evaluation</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetEvaluationResponse extends MachineLearningResponse implements
        ToCopyableBuilder<GetEvaluationResponse.Builder, GetEvaluationResponse> {
    private final String evaluationId;

    private final String mlModelId;

    private final String evaluationDataSourceId;

    private final String inputDataLocationS3;

    private final String createdByIamUser;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String status;

    private final PerformanceMetrics performanceMetrics;

    private final String logUri;

    private final String message;

    private final Long computeTime;

    private final Instant finishedAt;

    private final Instant startedAt;

    private GetEvaluationResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationId = builder.evaluationId;
        this.mlModelId = builder.mlModelId;
        this.evaluationDataSourceId = builder.evaluationDataSourceId;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.performanceMetrics = builder.performanceMetrics;
        this.logUri = builder.logUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
    }

    /**
     * <p>
     * The evaluation ID which is same as the <code>EvaluationId</code> in the request.
     * </p>
     * 
     * @return The evaluation ID which is same as the <code>EvaluationId</code> in the request.
     */
    public String evaluationId() {
        return evaluationId;
    }

    /**
     * <p>
     * The ID of the <code>MLModel</code> that was the focus of the evaluation.
     * </p>
     * 
     * @return The ID of the <code>MLModel</code> that was the focus of the evaluation.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The <code>DataSource</code> used for this evaluation.
     * </p>
     * 
     * @return The <code>DataSource</code> used for this evaluation.
     */
    public String evaluationDataSourceId() {
        return evaluationDataSourceId;
    }

    /**
     * <p>
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public String inputDataLocationS3() {
        return inputDataLocationS3;
    }

    /**
     * <p>
     * The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS
     * Identity and Access Management (IAM) user account.
     * </p>
     * 
     * @return The AWS user account that invoked the evaluation. The account type can be either an AWS root account or
     *         an AWS Identity and Access Management (IAM) user account.
     */
    public String createdByIamUser() {
        return createdByIamUser;
    }

    /**
     * <p>
     * The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>Evaluation</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>Evaluation</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The status of the evaluation. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an
     * <code>MLModel</code>.</li>
     * <li> <code>INPROGRESS</code> - The evaluation is underway.</li>
     * <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is not
     * usable.</li>
     * <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the evaluation. This element can have one of the following values:</p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an
     *         <code>MLModel</code>.</li>
     *         <li> <code>INPROGRESS</code> - The evaluation is underway.</li>
     *         <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It
     *         is not usable.</li>
     *         <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li>
     * @see EntityStatus
     */
    public EntityStatus status() {
        return EntityStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the evaluation. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an
     * <code>MLModel</code>.</li>
     * <li> <code>INPROGRESS</code> - The evaluation is underway.</li>
     * <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is not
     * usable.</li>
     * <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the evaluation. This element can have one of the following values:</p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an
     *         <code>MLModel</code>.</li>
     *         <li> <code>INPROGRESS</code> - The evaluation is underway.</li>
     *         <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It
     *         is not usable.</li>
     *         <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li>
     * @see EntityStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Measurements of how well the <code>MLModel</code> performed using observations referenced by the
     * <code>DataSource</code>. One of the following metric is returned based on the type of the <code>MLModel</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance.
     * </p>
     * </li>
     * <li>
     * <p>
     * RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure
     * performance. RMSE measures the difference between predicted and actual values for a single variable.
     * </p>
     * </li>
     * <li>
     * <p>
     * MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about performance metrics, please see the <a
     * href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.
     * </p>
     * 
     * @return Measurements of how well the <code>MLModel</code> performed using observations referenced by the
     *         <code>DataSource</code>. One of the following metric is returned based on the type of the
     *         <code>MLModel</code>: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure
     *         performance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to
     *         measure performance. RMSE measures the difference between predicted and actual values for a single
     *         variable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure
     *         performance.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about performance metrics, please see the <a
     *         href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.
     */
    public PerformanceMetrics performanceMetrics() {
        return performanceMetrics;
    }

    /**
     * <p>
     * A link to the file that contains logs of the <code>CreateEvaluation</code> operation.
     * </p>
     * 
     * @return A link to the file that contains logs of the <code>CreateEvaluation</code> operation.
     */
    public String logUri() {
        return logUri;
    }

    /**
     * <p>
     * A description of the most recent details about evaluating the <code>MLModel</code>.
     * </p>
     * 
     * @return A description of the most recent details about evaluating the <code>MLModel</code>.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
     * <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
     * available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.
     * </p>
     * 
     * @return The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
     *         <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
     *         available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.
     */
    public Long computeTime() {
        return computeTime;
    }

    /**
     * <p>
     * The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>COMPLETED</code> or
     * <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>Evaluation</code> is in the
     * <code>COMPLETED</code> or <code>FAILED</code> state.
     * </p>
     * 
     * @return The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>COMPLETED</code>
     *         or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>Evaluation</code> is in
     *         the <code>COMPLETED</code> or <code>FAILED</code> state.
     */
    public Instant finishedAt() {
        return finishedAt;
    }

    /**
     * <p>
     * The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>INPROGRESS</code>.
     * <code>StartedAt</code> isn't available if the <code>Evaluation</code> is in the <code>PENDING</code> state.
     * </p>
     * 
     * @return The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>INPROGRESS</code>
     *         . <code>StartedAt</code> isn't available if the <code>Evaluation</code> is in the <code>PENDING</code>
     *         state.
     */
    public Instant startedAt() {
        return startedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(createdByIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(performanceMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(logUri());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(computeTime());
        hashCode = 31 * hashCode + Objects.hashCode(finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvaluationResponse)) {
            return false;
        }
        GetEvaluationResponse other = (GetEvaluationResponse) obj;
        return Objects.equals(evaluationId(), other.evaluationId()) && Objects.equals(mlModelId(), other.mlModelId())
                && Objects.equals(evaluationDataSourceId(), other.evaluationDataSourceId())
                && Objects.equals(inputDataLocationS3(), other.inputDataLocationS3())
                && Objects.equals(createdByIamUser(), other.createdByIamUser()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(performanceMetrics(), other.performanceMetrics()) && Objects.equals(logUri(), other.logUri())
                && Objects.equals(message(), other.message()) && Objects.equals(computeTime(), other.computeTime())
                && Objects.equals(finishedAt(), other.finishedAt()) && Objects.equals(startedAt(), other.startedAt());
    }

    @Override
    public String toString() {
        return ToString.builder("GetEvaluationResponse").add("EvaluationId", evaluationId()).add("MLModelId", mlModelId())
                .add("EvaluationDataSourceId", evaluationDataSourceId()).add("InputDataLocationS3", inputDataLocationS3())
                .add("CreatedByIamUser", createdByIamUser()).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("Name", name()).add("Status", statusAsString()).add("PerformanceMetrics", performanceMetrics())
                .add("LogUri", logUri()).add("Message", message()).add("ComputeTime", computeTime())
                .add("FinishedAt", finishedAt()).add("StartedAt", startedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.of(clazz.cast(evaluationId()));
        case "MLModelId":
            return Optional.of(clazz.cast(mlModelId()));
        case "EvaluationDataSourceId":
            return Optional.of(clazz.cast(evaluationDataSourceId()));
        case "InputDataLocationS3":
            return Optional.of(clazz.cast(inputDataLocationS3()));
        case "CreatedByIamUser":
            return Optional.of(clazz.cast(createdByIamUser()));
        case "CreatedAt":
            return Optional.of(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.of(clazz.cast(lastUpdatedAt()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Status":
            return Optional.of(clazz.cast(statusAsString()));
        case "PerformanceMetrics":
            return Optional.of(clazz.cast(performanceMetrics()));
        case "LogUri":
            return Optional.of(clazz.cast(logUri()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        case "ComputeTime":
            return Optional.of(clazz.cast(computeTime()));
        case "FinishedAt":
            return Optional.of(clazz.cast(finishedAt()));
        case "StartedAt":
            return Optional.of(clazz.cast(startedAt()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MachineLearningResponse.Builder, CopyableBuilder<Builder, GetEvaluationResponse> {
        /**
         * <p>
         * The evaluation ID which is same as the <code>EvaluationId</code> in the request.
         * </p>
         * 
         * @param evaluationId
         *        The evaluation ID which is same as the <code>EvaluationId</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);

        /**
         * <p>
         * The ID of the <code>MLModel</code> that was the focus of the evaluation.
         * </p>
         * 
         * @param mlModelId
         *        The ID of the <code>MLModel</code> that was the focus of the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The <code>DataSource</code> used for this evaluation.
         * </p>
         * 
         * @param evaluationDataSourceId
         *        The <code>DataSource</code> used for this evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationDataSourceId(String evaluationDataSourceId);

        /**
         * <p>
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param inputDataLocationS3
         *        The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataLocationS3(String inputDataLocationS3);

        /**
         * <p>
         * The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an
         * AWS Identity and Access Management (IAM) user account.
         * </p>
         * 
         * @param createdByIamUser
         *        The AWS user account that invoked the evaluation. The account type can be either an AWS root account
         *        or an AWS Identity and Access Management (IAM) user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByIamUser(String createdByIamUser);

        /**
         * <p>
         * The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * A user-supplied name or description of the <code>Evaluation</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name or description of the <code>Evaluation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the evaluation. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an
         * <code>MLModel</code>.</li>
         * <li> <code>INPROGRESS</code> - The evaluation is underway.</li>
         * <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is
         * not usable.</li>
         * <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The status of the evaluation. This element can have one of the following values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an
         *        <code>MLModel</code>.</li>
         *        <li> <code>INPROGRESS</code> - The evaluation is underway.</li>
         *        <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion.
         *        It is not usable.</li>
         *        <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the evaluation. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an
         * <code>MLModel</code>.</li>
         * <li> <code>INPROGRESS</code> - The evaluation is underway.</li>
         * <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is
         * not usable.</li>
         * <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li>
         * </ul>
         * 
         * @param status
         *        The status of the evaluation. This element can have one of the following values:</p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an
         *        <code>MLModel</code>.</li>
         *        <li> <code>INPROGRESS</code> - The evaluation is underway.</li>
         *        <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion.
         *        It is not usable.</li>
         *        <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li>
         * @see EntityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(EntityStatus status);

        /**
         * <p>
         * Measurements of how well the <code>MLModel</code> performed using observations referenced by the
         * <code>DataSource</code>. One of the following metric is returned based on the type of the
         * <code>MLModel</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure
         * performance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure
         * performance. RMSE measures the difference between predicted and actual values for a single variable.
         * </p>
         * </li>
         * <li>
         * <p>
         * MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about performance metrics, please see the <a
         * href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.
         * </p>
         * 
         * @param performanceMetrics
         *        Measurements of how well the <code>MLModel</code> performed using observations referenced by the
         *        <code>DataSource</code>. One of the following metric is returned based on the type of the
         *        <code>MLModel</code>: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure
         *        performance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to
         *        measure performance. RMSE measures the difference between predicted and actual values for a single
         *        variable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure
         *        performance.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about performance metrics, please see the <a
         *        href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceMetrics(PerformanceMetrics performanceMetrics);

        /**
         * <p>
         * Measurements of how well the <code>MLModel</code> performed using observations referenced by the
         * <code>DataSource</code>. One of the following metric is returned based on the type of the
         * <code>MLModel</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure
         * performance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure
         * performance. RMSE measures the difference between predicted and actual values for a single variable.
         * </p>
         * </li>
         * <li>
         * <p>
         * MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about performance metrics, please see the <a
         * href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link PerformanceMetrics.Builder} avoiding the need to
         * create one manually via {@link PerformanceMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link PerformanceMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #performanceMetrics(PerformanceMetrics)}.
         * 
         * @param performanceMetrics
         *        a consumer that will call methods on {@link PerformanceMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performanceMetrics(PerformanceMetrics)
         */
        default Builder performanceMetrics(Consumer<PerformanceMetrics.Builder> performanceMetrics) {
            return performanceMetrics(PerformanceMetrics.builder().apply(performanceMetrics).build());
        }

        /**
         * <p>
         * A link to the file that contains logs of the <code>CreateEvaluation</code> operation.
         * </p>
         * 
         * @param logUri
         *        A link to the file that contains logs of the <code>CreateEvaluation</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * A description of the most recent details about evaluating the <code>MLModel</code>.
         * </p>
         * 
         * @param message
         *        A description of the most recent details about evaluating the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
         * <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only
         * available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.
         * </p>
         * 
         * @param computeTime
         *        The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the
         *        <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is
         *        only available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTime(Long computeTime);

        /**
         * <p>
         * The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>COMPLETED</code> or
         * <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>Evaluation</code> is in the
         * <code>COMPLETED</code> or <code>FAILED</code> state.
         * </p>
         * 
         * @param finishedAt
         *        The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as
         *        <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the
         *        <code>Evaluation</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * <p>
         * The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>INPROGRESS</code>.
         * <code>StartedAt</code> isn't available if the <code>Evaluation</code> is in the <code>PENDING</code> state.
         * </p>
         * 
         * @param startedAt
         *        The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as
         *        <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>Evaluation</code> is in
         *        the <code>PENDING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String evaluationId;

        private String mlModelId;

        private String evaluationDataSourceId;

        private String inputDataLocationS3;

        private String createdByIamUser;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String name;

        private String status;

        private PerformanceMetrics performanceMetrics;

        private String logUri;

        private String message;

        private Long computeTime;

        private Instant finishedAt;

        private Instant startedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvaluationResponse model) {
            super(model);
            evaluationId(model.evaluationId);
            mlModelId(model.mlModelId);
            evaluationDataSourceId(model.evaluationDataSourceId);
            inputDataLocationS3(model.inputDataLocationS3);
            createdByIamUser(model.createdByIamUser);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            status(model.status);
            performanceMetrics(model.performanceMetrics);
            logUri(model.logUri);
            message(model.message);
            computeTime(model.computeTime);
            finishedAt(model.finishedAt);
            startedAt(model.startedAt);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getEvaluationDataSourceId() {
            return evaluationDataSourceId;
        }

        @Override
        public final Builder evaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
            return this;
        }

        public final void setEvaluationDataSourceId(String evaluationDataSourceId) {
            this.evaluationDataSourceId = evaluationDataSourceId;
        }

        public final String getInputDataLocationS3() {
            return inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getCreatedByIamUser() {
            return createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final PerformanceMetrics.Builder getPerformanceMetrics() {
            return performanceMetrics != null ? performanceMetrics.toBuilder() : null;
        }

        @Override
        public final Builder performanceMetrics(PerformanceMetrics performanceMetrics) {
            this.performanceMetrics = performanceMetrics;
            return this;
        }

        public final void setPerformanceMetrics(PerformanceMetrics.BuilderImpl performanceMetrics) {
            this.performanceMetrics = performanceMetrics != null ? performanceMetrics.build() : null;
        }

        public final String getLogUri() {
            return logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public GetEvaluationResponse build() {
            return new GetEvaluationResponse(this);
        }
    }
}
