/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.machinelearning.model.MLModel;
import software.amazon.awssdk.services.machinelearning.transform.RealtimeEndpointInfoUnmarshaller;

public class MLModelUnmarshaller
implements Unmarshaller<MLModel, JsonUnmarshallerContext> {
    private static MLModelUnmarshaller INSTANCE;

    public MLModel unmarshall(JsonUnmarshallerContext context) throws Exception {
        MLModel.Builder mlModelBuilder = MLModel.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("MLModelId", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.mlModelId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TrainingDataSourceId", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.trainingDataSourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedByIamUser", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.createdByIamUser((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.createdAt((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdatedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.lastUpdatedAt((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SizeInBytes", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.sizeInBytes((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndpointInfo", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.endpointInfo(RealtimeEndpointInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TrainingParameters", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.trainingParameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("InputDataLocationS3", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.inputDataLocationS3((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Algorithm", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.algorithm((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MLModelType", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.mlModelType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ScoreThreshold", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.scoreThreshold((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("ScoreThresholdLastUpdatedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.scoreThresholdLastUpdatedAt((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
                if (context.testExpression("Message", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.message((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ComputeTime", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.computeTime((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("FinishedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.finishedAt((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
                if (context.testExpression("StartedAt", targetDepth)) {
                    context.nextToken();
                    mlModelBuilder.startedAt((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MLModel)mlModelBuilder.build();
    }

    public static MLModelUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MLModelUnmarshaller();
        }
        return INSTANCE;
    }
}

