/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftDatabaseCredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftDatabaseCredentials
implements StructuredPojo,
ToCopyableBuilder<Builder, RedshiftDatabaseCredentials> {
    private final String username;
    private final String password;

    private RedshiftDatabaseCredentials(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.username() == null ? 0 : this.username().hashCode());
        hashCode = 31 * hashCode + (this.password() == null ? 0 : this.password().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDatabaseCredentials)) {
            return false;
        }
        RedshiftDatabaseCredentials other = (RedshiftDatabaseCredentials)obj;
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        if (other.password() == null ^ this.password() == null) {
            return false;
        }
        return other.password() == null || other.password().equals(this.password());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.username() != null) {
            sb.append("Username: ").append(this.username()).append(",");
        }
        if (this.password() != null) {
            sb.append("Password: ").append(this.password()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDatabaseCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String username;
        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDatabaseCredentials model) {
            this.setUsername(model.username);
            this.setPassword(model.password);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public RedshiftDatabaseCredentials build() {
            return new RedshiftDatabaseCredentials(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedshiftDatabaseCredentials> {
        public Builder username(String var1);

        public Builder password(String var1);
    }
}

