/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;
import software.amazon.awssdk.services.machinelearning.transform.RDSMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RDSMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, RDSMetadata> {
    private final RDSDatabase database;
    private final String databaseUserName;
    private final String selectSqlQuery;
    private final String resourceRole;
    private final String serviceRole;
    private final String dataPipelineId;

    private RDSMetadata(BuilderImpl builder) {
        this.database = builder.database;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.resourceRole = builder.resourceRole;
        this.serviceRole = builder.serviceRole;
        this.dataPipelineId = builder.dataPipelineId;
    }

    public RDSDatabase database() {
        return this.database;
    }

    public String databaseUserName() {
        return this.databaseUserName;
    }

    public String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public String resourceRole() {
        return this.resourceRole;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public String dataPipelineId() {
        return this.dataPipelineId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.database() == null ? 0 : this.database().hashCode());
        hashCode = 31 * hashCode + (this.databaseUserName() == null ? 0 : this.databaseUserName().hashCode());
        hashCode = 31 * hashCode + (this.selectSqlQuery() == null ? 0 : this.selectSqlQuery().hashCode());
        hashCode = 31 * hashCode + (this.resourceRole() == null ? 0 : this.resourceRole().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        hashCode = 31 * hashCode + (this.dataPipelineId() == null ? 0 : this.dataPipelineId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSMetadata)) {
            return false;
        }
        RDSMetadata other = (RDSMetadata)obj;
        if (other.database() == null ^ this.database() == null) {
            return false;
        }
        if (other.database() != null && !other.database().equals(this.database())) {
            return false;
        }
        if (other.databaseUserName() == null ^ this.databaseUserName() == null) {
            return false;
        }
        if (other.databaseUserName() != null && !other.databaseUserName().equals(this.databaseUserName())) {
            return false;
        }
        if (other.selectSqlQuery() == null ^ this.selectSqlQuery() == null) {
            return false;
        }
        if (other.selectSqlQuery() != null && !other.selectSqlQuery().equals(this.selectSqlQuery())) {
            return false;
        }
        if (other.resourceRole() == null ^ this.resourceRole() == null) {
            return false;
        }
        if (other.resourceRole() != null && !other.resourceRole().equals(this.resourceRole())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.dataPipelineId() == null ^ this.dataPipelineId() == null) {
            return false;
        }
        return other.dataPipelineId() == null || other.dataPipelineId().equals(this.dataPipelineId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.database() != null) {
            sb.append("Database: ").append(this.database()).append(",");
        }
        if (this.databaseUserName() != null) {
            sb.append("DatabaseUserName: ").append(this.databaseUserName()).append(",");
        }
        if (this.selectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(this.selectSqlQuery()).append(",");
        }
        if (this.resourceRole() != null) {
            sb.append("ResourceRole: ").append(this.resourceRole()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.dataPipelineId() != null) {
            sb.append("DataPipelineId: ").append(this.dataPipelineId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private RDSDatabase database;
        private String databaseUserName;
        private String selectSqlQuery;
        private String resourceRole;
        private String serviceRole;
        private String dataPipelineId;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSMetadata model) {
            this.setDatabase(model.database);
            this.setDatabaseUserName(model.databaseUserName);
            this.setSelectSqlQuery(model.selectSqlQuery);
            this.setResourceRole(model.resourceRole);
            this.setServiceRole(model.serviceRole);
            this.setDataPipelineId(model.dataPipelineId);
        }

        public final RDSDatabase getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(RDSDatabase database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(RDSDatabase database) {
            this.database = database;
        }

        public final String getDatabaseUserName() {
            return this.databaseUserName;
        }

        @Override
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public final String getResourceRole() {
            return this.resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getDataPipelineId() {
            return this.dataPipelineId;
        }

        @Override
        public final Builder dataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
            return this;
        }

        public final void setDataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
        }

        public RDSMetadata build() {
            return new RDSMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RDSMetadata> {
        public Builder database(RDSDatabase var1);

        public Builder databaseUserName(String var1);

        public Builder selectSqlQuery(String var1);

        public Builder resourceRole(String var1);

        public Builder serviceRole(String var1);

        public Builder dataPipelineId(String var1);
    }
}

