/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.internal;

import java.net.URI;
import java.net.URISyntaxException;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;

public class PredictEndpointHandler
extends RequestHandler {
    public SdkHttpFullRequest beforeRequest(SdkHttpFullRequest request) {
        Object originalRequest = ((RequestConfig)request.handlerContext(AwsHandlerKeys.REQUEST_CONFIG)).getOriginalRequest();
        if (originalRequest instanceof PredictRequest) {
            PredictRequest pr = (PredictRequest)((Object)originalRequest);
            if (pr.predictEndpoint() == null) {
                throw new AmazonClientException("PredictRequest.PredictEndpoint is required!");
            }
            try {
                return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).endpoint(new URI(pr.predictEndpoint())).build();
            }
            catch (URISyntaxException e) {
                throw new AmazonClientException("Unable to parse PredictRequest.PredictEndpoint", (Throwable)e);
            }
        }
        return request;
    }
}

