/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.machinelearning.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * RedshiftDataSpecMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class RedshiftDataSpecMarshaller {

    private static final MarshallingInfo<StructuredPojo> DATABASEINFORMATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DatabaseInformation").build();
    private static final MarshallingInfo<String> SELECTSQLQUERY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectSqlQuery").build();
    private static final MarshallingInfo<StructuredPojo> DATABASECREDENTIALS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DatabaseCredentials").build();
    private static final MarshallingInfo<String> S3STAGINGLOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3StagingLocation").build();
    private static final MarshallingInfo<String> DATAREARRANGEMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataRearrangement").build();
    private static final MarshallingInfo<String> DATASCHEMA_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchema").build();
    private static final MarshallingInfo<String> DATASCHEMAURI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSchemaUri").build();

    private static final RedshiftDataSpecMarshaller instance = new RedshiftDataSpecMarshaller();

    public static RedshiftDataSpecMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(RedshiftDataSpec redshiftDataSpec, ProtocolMarshaller protocolMarshaller) {

        if (redshiftDataSpec == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(redshiftDataSpec.databaseInformation(), DATABASEINFORMATION_BINDING);
            protocolMarshaller.marshall(redshiftDataSpec.selectSqlQuery(), SELECTSQLQUERY_BINDING);
            protocolMarshaller.marshall(redshiftDataSpec.databaseCredentials(), DATABASECREDENTIALS_BINDING);
            protocolMarshaller.marshall(redshiftDataSpec.s3StagingLocation(), S3STAGINGLOCATION_BINDING);
            protocolMarshaller.marshall(redshiftDataSpec.dataRearrangement(), DATAREARRANGEMENT_BINDING);
            protocolMarshaller.marshall(redshiftDataSpec.dataSchema(), DATASCHEMA_BINDING);
            protocolMarshaller.marshall(redshiftDataSpec.dataSchemaUri(), DATASCHEMAURI_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
