/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDataSourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateDataSourceRequest.Builder, UpdateDataSourceRequest> {
    private final String dataSourceId;

    private final String dataSourceName;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
    }

    /**
     * <p>
     * The ID assigned to the <code>DataSource</code> during creation.
     * </p>
     * 
     * @return The ID assigned to the <code>DataSource</code> during creation.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A new user-supplied name or description of the <code>DataSource</code> that will replace the current description.
     * </p>
     * 
     * @return A new user-supplied name or description of the <code>DataSource</code> that will replace the current
     *         description.
     */
    public String dataSourceName() {
        return dataSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataSourceId() == null) ? 0 : dataSourceId().hashCode());
        hashCode = 31 * hashCode + ((dataSourceName() == null) ? 0 : dataSourceName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest) obj;
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.dataSourceName() == null ^ this.dataSourceName() == null) {
            return false;
        }
        if (other.dataSourceName() != null && !other.dataSourceName().equals(this.dataSourceName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dataSourceId() != null) {
            sb.append("DataSourceId: ").append(dataSourceId()).append(",");
        }
        if (dataSourceName() != null) {
            sb.append("DataSourceName: ").append(dataSourceName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDataSourceRequest> {
        /**
         * <p>
         * The ID assigned to the <code>DataSource</code> during creation.
         * </p>
         * 
         * @param dataSourceId
         *        The ID assigned to the <code>DataSource</code> during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A new user-supplied name or description of the <code>DataSource</code> that will replace the current
         * description.
         * </p>
         * 
         * @param dataSourceName
         *        A new user-supplied name or description of the <code>DataSource</code> that will replace the current
         *        description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);
    }

    private static final class BuilderImpl implements Builder {
        private String dataSourceId;

        private String dataSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            setDataSourceId(model.dataSourceId);
            setDataSourceName(model.dataSourceName);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }
    }
}
