/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RedshiftMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the <code>DataSource</code> details specific to Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RedshiftMetadata implements StructuredPojo, ToCopyableBuilder<RedshiftMetadata.Builder, RedshiftMetadata> {
    private final RedshiftDatabase redshiftDatabase;

    private final String databaseUserName;

    private final String selectSqlQuery;

    private RedshiftMetadata(BuilderImpl builder) {
        this.redshiftDatabase = builder.redshiftDatabase;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
    }

    /**
     *
     * @return
     */
    public RedshiftDatabase redshiftDatabase() {
        return redshiftDatabase;
    }

    /**
     *
     * @return
     */
    public String databaseUserName() {
        return databaseUserName;
    }

    /**
     * <p>
     * The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if <code>Verbose</code>
     * is true in GetDataSourceInput.
     * </p>
     * 
     * @return The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if
     *         <code>Verbose</code> is true in GetDataSourceInput.
     */
    public String selectSqlQuery() {
        return selectSqlQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((redshiftDatabase() == null) ? 0 : redshiftDatabase().hashCode());
        hashCode = 31 * hashCode + ((databaseUserName() == null) ? 0 : databaseUserName().hashCode());
        hashCode = 31 * hashCode + ((selectSqlQuery() == null) ? 0 : selectSqlQuery().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftMetadata)) {
            return false;
        }
        RedshiftMetadata other = (RedshiftMetadata) obj;
        if (other.redshiftDatabase() == null ^ this.redshiftDatabase() == null) {
            return false;
        }
        if (other.redshiftDatabase() != null && !other.redshiftDatabase().equals(this.redshiftDatabase())) {
            return false;
        }
        if (other.databaseUserName() == null ^ this.databaseUserName() == null) {
            return false;
        }
        if (other.databaseUserName() != null && !other.databaseUserName().equals(this.databaseUserName())) {
            return false;
        }
        if (other.selectSqlQuery() == null ^ this.selectSqlQuery() == null) {
            return false;
        }
        if (other.selectSqlQuery() != null && !other.selectSqlQuery().equals(this.selectSqlQuery())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (redshiftDatabase() != null) {
            sb.append("RedshiftDatabase: ").append(redshiftDatabase()).append(",");
        }
        if (databaseUserName() != null) {
            sb.append("DatabaseUserName: ").append(databaseUserName()).append(",");
        }
        if (selectSqlQuery() != null) {
            sb.append("SelectSqlQuery: ").append(selectSqlQuery()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RedshiftMetadata> {
        /**
         *
         * @param redshiftDatabase
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftDatabase(RedshiftDatabase redshiftDatabase);

        /**
         *
         * @param databaseUserName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseUserName(String databaseUserName);

        /**
         * <p>
         * The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if
         * <code>Verbose</code> is true in GetDataSourceInput.
         * </p>
         * 
         * @param selectSqlQuery
         *        The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if
         *        <code>Verbose</code> is true in GetDataSourceInput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectSqlQuery(String selectSqlQuery);
    }

    private static final class BuilderImpl implements Builder {
        private RedshiftDatabase redshiftDatabase;

        private String databaseUserName;

        private String selectSqlQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftMetadata model) {
            setRedshiftDatabase(model.redshiftDatabase);
            setDatabaseUserName(model.databaseUserName);
            setSelectSqlQuery(model.selectSqlQuery);
        }

        public final RedshiftDatabase getRedshiftDatabase() {
            return redshiftDatabase;
        }

        @Override
        public final Builder redshiftDatabase(RedshiftDatabase redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase;
            return this;
        }

        public final void setRedshiftDatabase(RedshiftDatabase redshiftDatabase) {
            this.redshiftDatabase = redshiftDatabase;
        }

        public final String getDatabaseUserName() {
            return databaseUserName;
        }

        @Override
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public final String getSelectSqlQuery() {
            return selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        @Override
        public RedshiftMetadata build() {
            return new RedshiftMetadata(this);
        }
    }
}
