/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.machinelearning.transform.RDSDatabaseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The database details of an Amazon RDS database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RDSDatabase implements StructuredPojo, ToCopyableBuilder<RDSDatabase.Builder, RDSDatabase> {
    private final String instanceIdentifier;

    private final String databaseName;

    private RDSDatabase(BuilderImpl builder) {
        this.instanceIdentifier = builder.instanceIdentifier;
        this.databaseName = builder.databaseName;
    }

    /**
     * <p>
     * The ID of an RDS DB instance.
     * </p>
     * 
     * @return The ID of an RDS DB instance.
     */
    public String instanceIdentifier() {
        return instanceIdentifier;
    }

    /**
     *
     * @return
     */
    public String databaseName() {
        return databaseName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceIdentifier() == null) ? 0 : instanceIdentifier().hashCode());
        hashCode = 31 * hashCode + ((databaseName() == null) ? 0 : databaseName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDatabase)) {
            return false;
        }
        RDSDatabase other = (RDSDatabase) obj;
        if (other.instanceIdentifier() == null ^ this.instanceIdentifier() == null) {
            return false;
        }
        if (other.instanceIdentifier() != null && !other.instanceIdentifier().equals(this.instanceIdentifier())) {
            return false;
        }
        if (other.databaseName() == null ^ this.databaseName() == null) {
            return false;
        }
        if (other.databaseName() != null && !other.databaseName().equals(this.databaseName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceIdentifier() != null) {
            sb.append("InstanceIdentifier: ").append(instanceIdentifier()).append(",");
        }
        if (databaseName() != null) {
            sb.append("DatabaseName: ").append(databaseName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDatabaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RDSDatabase> {
        /**
         * <p>
         * The ID of an RDS DB instance.
         * </p>
         * 
         * @param instanceIdentifier
         *        The ID of an RDS DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdentifier(String instanceIdentifier);

        /**
         *
         * @param databaseName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceIdentifier;

        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDatabase model) {
            setInstanceIdentifier(model.instanceIdentifier);
            setDatabaseName(model.databaseName);
        }

        public final String getInstanceIdentifier() {
            return instanceIdentifier;
        }

        @Override
        public final Builder instanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        public final void setInstanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public RDSDatabase build() {
            return new RDSDatabase(this);
        }
    }
}
