/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.machinelearning.transform.PredictionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from a <code>Predict</code> operation:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Details</code> - Contains the following attributes:
 * <code>DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY | MULTICLASS</code>
 * <code>DetailsAttributes.ALGORITHM - SGD</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PredictedLabel</code> - Present for either a <code>BINARY</code> or <code>MULTICLASS</code>
 * <code>MLModel</code> request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PredictedScores</code> - Contains the raw classification score corresponding to each label.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>PredictedValue</code> - Present for a <code>REGRESSION</code> <code>MLModel</code> request.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class Prediction implements StructuredPojo, ToCopyableBuilder<Prediction.Builder, Prediction> {
    private final String predictedLabel;

    private final Float predictedValue;

    private final Map<String, Float> predictedScores;

    private final Map<String, String> details;

    private Prediction(BuilderImpl builder) {
        this.predictedLabel = builder.predictedLabel;
        this.predictedValue = builder.predictedValue;
        this.predictedScores = builder.predictedScores;
        this.details = builder.details;
    }

    /**
     * <p>
     * The prediction label for either a <code>BINARY</code> or <code>MULTICLASS</code> <code>MLModel</code>.
     * </p>
     * 
     * @return The prediction label for either a <code>BINARY</code> or <code>MULTICLASS</code> <code>MLModel</code>.
     */
    public String predictedLabel() {
        return predictedLabel;
    }

    /**
     * The prediction value for <code>REGRESSION</code> <code>MLModel</code>.
     * 
     * @return The prediction value for <code>REGRESSION</code> <code>MLModel</code>.
     */
    public Float predictedValue() {
        return predictedValue;
    }

    /**
     *
     * @return
     */
    public Map<String, Float> predictedScores() {
        return predictedScores;
    }

    /**
     *
     * @return
     */
    public Map<String, String> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((predictedLabel() == null) ? 0 : predictedLabel().hashCode());
        hashCode = 31 * hashCode + ((predictedValue() == null) ? 0 : predictedValue().hashCode());
        hashCode = 31 * hashCode + ((predictedScores() == null) ? 0 : predictedScores().hashCode());
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prediction)) {
            return false;
        }
        Prediction other = (Prediction) obj;
        if (other.predictedLabel() == null ^ this.predictedLabel() == null) {
            return false;
        }
        if (other.predictedLabel() != null && !other.predictedLabel().equals(this.predictedLabel())) {
            return false;
        }
        if (other.predictedValue() == null ^ this.predictedValue() == null) {
            return false;
        }
        if (other.predictedValue() != null && !other.predictedValue().equals(this.predictedValue())) {
            return false;
        }
        if (other.predictedScores() == null ^ this.predictedScores() == null) {
            return false;
        }
        if (other.predictedScores() != null && !other.predictedScores().equals(this.predictedScores())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (predictedLabel() != null) {
            sb.append("PredictedLabel: ").append(predictedLabel()).append(",");
        }
        if (predictedValue() != null) {
            sb.append("PredictedValue: ").append(predictedValue()).append(",");
        }
        if (predictedScores() != null) {
            sb.append("PredictedScores: ").append(predictedScores()).append(",");
        }
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredictionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Prediction> {
        /**
         * <p>
         * The prediction label for either a <code>BINARY</code> or <code>MULTICLASS</code> <code>MLModel</code>.
         * </p>
         * 
         * @param predictedLabel
         *        The prediction label for either a <code>BINARY</code> or <code>MULTICLASS</code> <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictedLabel(String predictedLabel);

        /**
         * The prediction value for <code>REGRESSION</code> <code>MLModel</code>.
         * 
         * @param predictedValue
         *        The prediction value for <code>REGRESSION</code> <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictedValue(Float predictedValue);

        /**
         *
         * @param predictedScores
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictedScores(Map<String, Float> predictedScores);

        /**
         *
         * @param details
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Map<String, String> details);
    }

    private static final class BuilderImpl implements Builder {
        private String predictedLabel;

        private Float predictedValue;

        private Map<String, Float> predictedScores = new SdkInternalMap<>();

        private Map<String, String> details = new SdkInternalMap<>();

        private BuilderImpl() {
        }

        private BuilderImpl(Prediction model) {
            setPredictedLabel(model.predictedLabel);
            setPredictedValue(model.predictedValue);
            setPredictedScores(model.predictedScores);
            setDetails(model.details);
        }

        public final String getPredictedLabel() {
            return predictedLabel;
        }

        @Override
        public final Builder predictedLabel(String predictedLabel) {
            this.predictedLabel = predictedLabel;
            return this;
        }

        public final void setPredictedLabel(String predictedLabel) {
            this.predictedLabel = predictedLabel;
        }

        public final Float getPredictedValue() {
            return predictedValue;
        }

        @Override
        public final Builder predictedValue(Float predictedValue) {
            this.predictedValue = predictedValue;
            return this;
        }

        public final void setPredictedValue(Float predictedValue) {
            this.predictedValue = predictedValue;
        }

        public final Map<String, Float> getPredictedScores() {
            return predictedScores;
        }

        @Override
        public final Builder predictedScores(Map<String, Float> predictedScores) {
            this.predictedScores = ScoreValuePerLabelMapCopier.copy(predictedScores);
            return this;
        }

        public final void setPredictedScores(Map<String, Float> predictedScores) {
            this.predictedScores = ScoreValuePerLabelMapCopier.copy(predictedScores);
        }

        public final Map<String, String> getDetails() {
            return details;
        }

        @Override
        public final Builder details(Map<String, String> details) {
            this.details = DetailsMapCopier.copy(details);
            return this;
        }

        public final void setDetails(Map<String, String> details) {
            this.details = DetailsMapCopier.copy(details);
        }

        @Override
        public Prediction build() {
            return new Prediction(this);
        }
    }
}
