/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Date;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.machinelearning.transform.MLModelMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetMLModel</code> operation.
 * </p>
 * <p>
 * The content consists of the detailed metadata and the current status of the <code>MLModel</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MLModel implements StructuredPojo, ToCopyableBuilder<MLModel.Builder, MLModel> {
    private final String mlModelId;

    private final String trainingDataSourceId;

    private final String createdByIamUser;

    private final Date createdAt;

    private final Date lastUpdatedAt;

    private final String name;

    private final String status;

    private final Long sizeInBytes;

    private final RealtimeEndpointInfo endpointInfo;

    private final Map<String, String> trainingParameters;

    private final String inputDataLocationS3;

    private final String algorithm;

    private final String mlModelType;

    private final Float scoreThreshold;

    private final Date scoreThresholdLastUpdatedAt;

    private final String message;

    private final Long computeTime;

    private final Date finishedAt;

    private final Date startedAt;

    private MLModel(BuilderImpl builder) {
        this.mlModelId = builder.mlModelId;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.sizeInBytes = builder.sizeInBytes;
        this.endpointInfo = builder.endpointInfo;
        this.trainingParameters = builder.trainingParameters;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.algorithm = builder.algorithm;
        this.mlModelType = builder.mlModelType;
        this.scoreThreshold = builder.scoreThreshold;
        this.scoreThresholdLastUpdatedAt = builder.scoreThresholdLastUpdatedAt;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
    }

    /**
     * <p>
     * The ID assigned to the <code>MLModel</code> at creation.
     * </p>
     * 
     * @return The ID assigned to the <code>MLModel</code> at creation.
     */
    public String mlModelId() {
        return mlModelId;
    }

    /**
     * <p>
     * The ID of the training <code>DataSource</code>. The <code>CreateMLModel</code> operation uses the
     * <code>TrainingDataSourceId</code>.
     * </p>
     * 
     * @return The ID of the training <code>DataSource</code>. The <code>CreateMLModel</code> operation uses the
     *         <code>TrainingDataSourceId</code>.
     */
    public String trainingDataSourceId() {
        return trainingDataSourceId;
    }

    /**
     * <p>
     * The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root
     * account or an AWS Identity and Access Management (IAM) user account.
     * </p>
     * 
     * @return The AWS user account from which the <code>MLModel</code> was created. The account type can be either an
     *         AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    public String createdByIamUser() {
        return createdByIamUser;
    }

    /**
     * <p>
     * The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
     */
    public Date createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
     */
    public Date lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>MLModel</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>MLModel</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current status of an <code>MLModel</code>. This element can have one of the following values:
     * </p>
     * <ul>
     * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
     * <code>MLModel</code>.</li>
     * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     * <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The model isn't
     * usable.</li>
     * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * </ul>
     * 
     * @return The current status of an <code>MLModel</code>. This element can have one of the following values: </p>
     *         <ul>
     *         <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
     *         <code>MLModel</code>.</li>
     *         <li> <code>INPROGRESS</code> - The creation process is underway.</li>
     *         <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The
     *         model isn't usable.</li>
     *         <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
     *         <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
     * @see EntityStatus
     */
    public String status() {
        return status;
    }

    /**
     *
     * @return
     */
    public Long sizeInBytes() {
        return sizeInBytes;
    }

    /**
     * <p>
     * The current endpoint of the <code>MLModel</code>.
     * </p>
     * 
     * @return The current endpoint of the <code>MLModel</code>.
     */
    public RealtimeEndpointInfo endpointInfo() {
        return endpointInfo;
    }

    /**
     * <p>
     * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
     * pairs.
     * </p>
     * <p>
     * The following is the current set of training parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the
     * size of the model might affect its performance.
     * </p>
     * <p>
     * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
     * <code>33554432</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build
     * the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The
     * default value is <code>10</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a
     * model's ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code>
     * and <code>none</code>. The default value is <code>none</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm, which controls overfitting the
     * data by penalizing large coefficients. This parameter tends to drive coefficients to zero, resulting in sparse
     * feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1
     * normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm, which controls overfitting the
     * data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this
     * parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     * </p>
     * <p>
     * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2
     * normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
     *         key-value pairs.</p>
     *         <p>
     *         The following is the current set of training parameters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
     *         data, the size of the model might affect its performance.
     *         </p>
     *         <p>
     *         The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
     *         value is <code>33554432</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
     *         build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
     *         <code>10000</code>. The default value is <code>10</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves
     *         a model's ability to find the optimal solution for a variety of data types. The valid values are
     *         <code>auto</code> and <code>none</code>. The default value is <code>none</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm, which controls
     *         overfitting the data by penalizing large coefficients. This parameter tends to drive coefficients to
     *         zero, resulting in sparse feature set. If you use this parameter, start by specifying a small value, such
     *         as <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm, which controls
     *         overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero
     *         values. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
     *         </p>
     *         <p>
     *         The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not
     *         use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
     *         sparingly.
     *         </p>
     *         </li>
     */
    public Map<String, String> trainingParameters() {
        return trainingParameters;
    }

    /**
     * <p>
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    public String inputDataLocationS3() {
        return inputDataLocationS3;
    }

    /**
     * <p>
     * The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:
     * </p>
     * <ul>
     * <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the gradient of
     * the loss function.</li>
     * </ul>
     * 
     * @return The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:</p>
     *         <ul>
     *         <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the
     *         gradient of the loss function.</li>
     * @see Algorithm
     */
    public String algorithm() {
        return algorithm;
    }

    /**
     * <p>
     * Identifies the <code>MLModel</code> category. The following are the available types:
     * </p>
     * <ul>
     * <li> <code>REGRESSION</code> - Produces a numeric result. For example, "What price should a house be listed at?"</li>
     * <li> <code>BINARY</code> - Produces one of two possible results. For example,
     * "Is this a child-friendly web site?".</li>
     * <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
     * "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
     * "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
     * </ul>
     * 
     * @return Identifies the <code>MLModel</code> category. The following are the available types:</p>
     *         <ul>
     *         <li> <code>REGRESSION</code> - Produces a numeric result. For example,
     *         "What price should a house be listed at?"</li>
     *         <li> <code>BINARY</code> - Produces one of two possible results. For example,
     *         "Is this a child-friendly web site?".</li>
     *         <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
     *         "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
     *         "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
     * @see MLModelType
     */
    public String mlModelType() {
        return mlModelType;
    }

    /**
     *
     * @return
     */
    public Float scoreThreshold() {
        return scoreThreshold;
    }

    /**
     * <p>
     * The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
     * </p>
     * 
     * @return The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
     */
    public Date scoreThresholdLastUpdatedAt() {
        return scoreThresholdLastUpdatedAt;
    }

    /**
     * <p>
     * A description of the most recent details about accessing the <code>MLModel</code>.
     * </p>
     * 
     * @return A description of the most recent details about accessing the <code>MLModel</code>.
     */
    public String message() {
        return message;
    }

    /**
     *
     * @return
     */
    public Long computeTime() {
        return computeTime;
    }

    /**
     *
     * @return
     */
    public Date finishedAt() {
        return finishedAt;
    }

    /**
     *
     * @return
     */
    public Date startedAt() {
        return startedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mlModelId() == null) ? 0 : mlModelId().hashCode());
        hashCode = 31 * hashCode + ((trainingDataSourceId() == null) ? 0 : trainingDataSourceId().hashCode());
        hashCode = 31 * hashCode + ((createdByIamUser() == null) ? 0 : createdByIamUser().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedAt() == null) ? 0 : lastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((sizeInBytes() == null) ? 0 : sizeInBytes().hashCode());
        hashCode = 31 * hashCode + ((endpointInfo() == null) ? 0 : endpointInfo().hashCode());
        hashCode = 31 * hashCode + ((trainingParameters() == null) ? 0 : trainingParameters().hashCode());
        hashCode = 31 * hashCode + ((inputDataLocationS3() == null) ? 0 : inputDataLocationS3().hashCode());
        hashCode = 31 * hashCode + ((algorithm() == null) ? 0 : algorithm().hashCode());
        hashCode = 31 * hashCode + ((mlModelType() == null) ? 0 : mlModelType().hashCode());
        hashCode = 31 * hashCode + ((scoreThreshold() == null) ? 0 : scoreThreshold().hashCode());
        hashCode = 31 * hashCode + ((scoreThresholdLastUpdatedAt() == null) ? 0 : scoreThresholdLastUpdatedAt().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((computeTime() == null) ? 0 : computeTime().hashCode());
        hashCode = 31 * hashCode + ((finishedAt() == null) ? 0 : finishedAt().hashCode());
        hashCode = 31 * hashCode + ((startedAt() == null) ? 0 : startedAt().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLModel)) {
            return false;
        }
        MLModel other = (MLModel) obj;
        if (other.mlModelId() == null ^ this.mlModelId() == null) {
            return false;
        }
        if (other.mlModelId() != null && !other.mlModelId().equals(this.mlModelId())) {
            return false;
        }
        if (other.trainingDataSourceId() == null ^ this.trainingDataSourceId() == null) {
            return false;
        }
        if (other.trainingDataSourceId() != null && !other.trainingDataSourceId().equals(this.trainingDataSourceId())) {
            return false;
        }
        if (other.createdByIamUser() == null ^ this.createdByIamUser() == null) {
            return false;
        }
        if (other.createdByIamUser() != null && !other.createdByIamUser().equals(this.createdByIamUser())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.lastUpdatedAt() == null ^ this.lastUpdatedAt() == null) {
            return false;
        }
        if (other.lastUpdatedAt() != null && !other.lastUpdatedAt().equals(this.lastUpdatedAt())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.sizeInBytes() == null ^ this.sizeInBytes() == null) {
            return false;
        }
        if (other.sizeInBytes() != null && !other.sizeInBytes().equals(this.sizeInBytes())) {
            return false;
        }
        if (other.endpointInfo() == null ^ this.endpointInfo() == null) {
            return false;
        }
        if (other.endpointInfo() != null && !other.endpointInfo().equals(this.endpointInfo())) {
            return false;
        }
        if (other.trainingParameters() == null ^ this.trainingParameters() == null) {
            return false;
        }
        if (other.trainingParameters() != null && !other.trainingParameters().equals(this.trainingParameters())) {
            return false;
        }
        if (other.inputDataLocationS3() == null ^ this.inputDataLocationS3() == null) {
            return false;
        }
        if (other.inputDataLocationS3() != null && !other.inputDataLocationS3().equals(this.inputDataLocationS3())) {
            return false;
        }
        if (other.algorithm() == null ^ this.algorithm() == null) {
            return false;
        }
        if (other.algorithm() != null && !other.algorithm().equals(this.algorithm())) {
            return false;
        }
        if (other.mlModelType() == null ^ this.mlModelType() == null) {
            return false;
        }
        if (other.mlModelType() != null && !other.mlModelType().equals(this.mlModelType())) {
            return false;
        }
        if (other.scoreThreshold() == null ^ this.scoreThreshold() == null) {
            return false;
        }
        if (other.scoreThreshold() != null && !other.scoreThreshold().equals(this.scoreThreshold())) {
            return false;
        }
        if (other.scoreThresholdLastUpdatedAt() == null ^ this.scoreThresholdLastUpdatedAt() == null) {
            return false;
        }
        if (other.scoreThresholdLastUpdatedAt() != null
                && !other.scoreThresholdLastUpdatedAt().equals(this.scoreThresholdLastUpdatedAt())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.computeTime() == null ^ this.computeTime() == null) {
            return false;
        }
        if (other.computeTime() != null && !other.computeTime().equals(this.computeTime())) {
            return false;
        }
        if (other.finishedAt() == null ^ this.finishedAt() == null) {
            return false;
        }
        if (other.finishedAt() != null && !other.finishedAt().equals(this.finishedAt())) {
            return false;
        }
        if (other.startedAt() == null ^ this.startedAt() == null) {
            return false;
        }
        if (other.startedAt() != null && !other.startedAt().equals(this.startedAt())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (mlModelId() != null) {
            sb.append("MLModelId: ").append(mlModelId()).append(",");
        }
        if (trainingDataSourceId() != null) {
            sb.append("TrainingDataSourceId: ").append(trainingDataSourceId()).append(",");
        }
        if (createdByIamUser() != null) {
            sb.append("CreatedByIamUser: ").append(createdByIamUser()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (lastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(lastUpdatedAt()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (sizeInBytes() != null) {
            sb.append("SizeInBytes: ").append(sizeInBytes()).append(",");
        }
        if (endpointInfo() != null) {
            sb.append("EndpointInfo: ").append(endpointInfo()).append(",");
        }
        if (trainingParameters() != null) {
            sb.append("TrainingParameters: ").append(trainingParameters()).append(",");
        }
        if (inputDataLocationS3() != null) {
            sb.append("InputDataLocationS3: ").append(inputDataLocationS3()).append(",");
        }
        if (algorithm() != null) {
            sb.append("Algorithm: ").append(algorithm()).append(",");
        }
        if (mlModelType() != null) {
            sb.append("MLModelType: ").append(mlModelType()).append(",");
        }
        if (scoreThreshold() != null) {
            sb.append("ScoreThreshold: ").append(scoreThreshold()).append(",");
        }
        if (scoreThresholdLastUpdatedAt() != null) {
            sb.append("ScoreThresholdLastUpdatedAt: ").append(scoreThresholdLastUpdatedAt()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (computeTime() != null) {
            sb.append("ComputeTime: ").append(computeTime()).append(",");
        }
        if (finishedAt() != null) {
            sb.append("FinishedAt: ").append(finishedAt()).append(",");
        }
        if (startedAt() != null) {
            sb.append("StartedAt: ").append(startedAt()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MLModelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MLModel> {
        /**
         * <p>
         * The ID assigned to the <code>MLModel</code> at creation.
         * </p>
         * 
         * @param mlModelId
         *        The ID assigned to the <code>MLModel</code> at creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);

        /**
         * <p>
         * The ID of the training <code>DataSource</code>. The <code>CreateMLModel</code> operation uses the
         * <code>TrainingDataSourceId</code>.
         * </p>
         * 
         * @param trainingDataSourceId
         *        The ID of the training <code>DataSource</code>. The <code>CreateMLModel</code> operation uses the
         *        <code>TrainingDataSourceId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSourceId(String trainingDataSourceId);

        /**
         * <p>
         * The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS
         * root account or an AWS Identity and Access Management (IAM) user account.
         * </p>
         * 
         * @param createdByIamUser
         *        The AWS user account from which the <code>MLModel</code> was created. The account type can be either
         *        an AWS root account or an AWS Identity and Access Management (IAM) user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByIamUser(String createdByIamUser);

        /**
         * <p>
         * The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
         * </p>
         * 
         * @param createdAt
         *        The time that the <code>MLModel</code> was created. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Date createdAt);

        /**
         * <p>
         * The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Date lastUpdatedAt);

        /**
         * <p>
         * A user-supplied name or description of the <code>MLModel</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name or description of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of an <code>MLModel</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
         * <code>MLModel</code>.</li>
         * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         * <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The model
         * isn't usable.</li>
         * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of an <code>MLModel</code>. This element can have one of the following values: </p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
         *        <code>MLModel</code>.</li>
         *        <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         *        <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The
         *        model isn't usable.</li>
         *        <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of an <code>MLModel</code>. This element can have one of the following values:
         * </p>
         * <ul>
         * <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
         * <code>MLModel</code>.</li>
         * <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         * <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The model
         * isn't usable.</li>
         * <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         * <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * </ul>
         * 
         * @param status
         *        The current status of an <code>MLModel</code>. This element can have one of the following values: </p>
         *        <ul>
         *        <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an
         *        <code>MLModel</code>.</li>
         *        <li> <code>INPROGRESS</code> - The creation process is underway.</li>
         *        <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn't run to completion. The
         *        model isn't usable.</li>
         *        <li> <code>COMPLETED</code> - The creation process completed successfully.</li>
         *        <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityStatus
         */
        Builder status(EntityStatus status);

        /**
         *
         * @param sizeInBytes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(Long sizeInBytes);

        /**
         * <p>
         * The current endpoint of the <code>MLModel</code>.
         * </p>
         * 
         * @param endpointInfo
         *        The current endpoint of the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointInfo(RealtimeEndpointInfo endpointInfo);

        /**
         * <p>
         * A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value
         * pairs.
         * </p>
         * <p>
         * The following is the current set of training parameters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data,
         * the size of the model might affect its performance.
         * </p>
         * <p>
         * The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is
         * <code>33554432</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to
         * build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>
         * . The default value is <code>10</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a
         * model's ability to find the optimal solution for a variety of data types. The valid values are
         * <code>auto</code> and <code>none</code>. The default value is <code>none</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm, which controls overfitting
         * the data by penalizing large coefficients. This parameter tends to drive coefficients to zero, resulting in
         * sparse feature set. If you use this parameter, start by specifying a small value, such as
         * <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm, which controls overfitting
         * the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you
         * use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.
         * </p>
         * <p>
         * The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use
         * L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter
         * sparingly.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trainingParameters
         *        A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of
         *        key-value pairs.</p>
         *        <p>
         *        The following is the current set of training parameters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input
         *        data, the size of the model might affect its performance.
         *        </p>
         *        <p>
         *        The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default
         *        value is <code>33554432</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations
         *        to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to
         *        <code>10000</code>. The default value is <code>10</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data
         *        improves a model's ability to find the optimal solution for a variety of data types. The valid values
         *        are <code>auto</code> and <code>none</code>. The default value is <code>none</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm, which controls
         *        overfitting the data by penalizing large coefficients. This parameter tends to drive coefficients to
         *        zero, resulting in sparse feature set. If you use this parameter, start by specifying a small value,
         *        such as <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm, which controls
         *        overfitting the data by penalizing large coefficients. This tends to drive coefficients to small,
         *        nonzero values. If you use this parameter, start by specifying a small value, such as
         *        <code>1.0E-08</code>.
         *        </p>
         *        <p>
         *        The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to
         *        not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this
         *        parameter sparingly.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingParameters(Map<String, String> trainingParameters);

        /**
         * <p>
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param inputDataLocationS3
         *        The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataLocationS3(String inputDataLocationS3);

        /**
         * <p>
         * The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:
         * </p>
         * <ul>
         * <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the gradient
         * of the loss function.</li>
         * </ul>
         * 
         * @param algorithm
         *        The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:</p>
         *        <ul>
         *        <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the
         *        gradient of the loss function.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(String algorithm);

        /**
         * <p>
         * The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:
         * </p>
         * <ul>
         * <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the gradient
         * of the loss function.</li>
         * </ul>
         * 
         * @param algorithm
         *        The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:</p>
         *        <ul>
         *        <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the
         *        gradient of the loss function.</li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(Algorithm algorithm);

        /**
         * <p>
         * Identifies the <code>MLModel</code> category. The following are the available types:
         * </p>
         * <ul>
         * <li> <code>REGRESSION</code> - Produces a numeric result. For example,
         * "What price should a house be listed at?"</li>
         * <li> <code>BINARY</code> - Produces one of two possible results. For example,
         * "Is this a child-friendly web site?".</li>
         * <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
         * "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
         * "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
         * </ul>
         * 
         * @param mlModelType
         *        Identifies the <code>MLModel</code> category. The following are the available types:</p>
         *        <ul>
         *        <li> <code>REGRESSION</code> - Produces a numeric result. For example,
         *        "What price should a house be listed at?"</li>
         *        <li> <code>BINARY</code> - Produces one of two possible results. For example,
         *        "Is this a child-friendly web site?".</li>
         *        <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
         *        "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="
         *        annbech" timestamp="20160328T175050-0700" content="
         *        "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(String mlModelType);

        /**
         * <p>
         * Identifies the <code>MLModel</code> category. The following are the available types:
         * </p>
         * <ul>
         * <li> <code>REGRESSION</code> - Produces a numeric result. For example,
         * "What price should a house be listed at?"</li>
         * <li> <code>BINARY</code> - Produces one of two possible results. For example,
         * "Is this a child-friendly web site?".</li>
         * <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
         * "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content="
         * "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li>
         * </ul>
         * 
         * @param mlModelType
         *        Identifies the <code>MLModel</code> category. The following are the available types:</p>
         *        <ul>
         *        <li> <code>REGRESSION</code> - Produces a numeric result. For example,
         *        "What price should a house be listed at?"</li>
         *        <li> <code>BINARY</code> - Produces one of two possible results. For example,
         *        "Is this a child-friendly web site?".</li>
         *        <li> <code>MULTICLASS</code> - Produces one of several possible results. For example,
         *        "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="
         *        annbech" timestamp="20160328T175050-0700" content="
         *        "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLModelType
         */
        Builder mlModelType(MLModelType mlModelType);

        /**
         *
         * @param scoreThreshold
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThreshold(Float scoreThreshold);

        /**
         * <p>
         * The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.
         * </p>
         * 
         * @param scoreThresholdLastUpdatedAt
         *        The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreThresholdLastUpdatedAt(Date scoreThresholdLastUpdatedAt);

        /**
         * <p>
         * A description of the most recent details about accessing the <code>MLModel</code>.
         * </p>
         * 
         * @param message
         *        A description of the most recent details about accessing the <code>MLModel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         *
         * @param computeTime
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTime(Long computeTime);

        /**
         *
         * @param finishedAt
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Date finishedAt);

        /**
         *
         * @param startedAt
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Date startedAt);
    }

    private static final class BuilderImpl implements Builder {
        private String mlModelId;

        private String trainingDataSourceId;

        private String createdByIamUser;

        private Date createdAt;

        private Date lastUpdatedAt;

        private String name;

        private String status;

        private Long sizeInBytes;

        private RealtimeEndpointInfo endpointInfo;

        private Map<String, String> trainingParameters = new SdkInternalMap<>();

        private String inputDataLocationS3;

        private String algorithm;

        private String mlModelType;

        private Float scoreThreshold;

        private Date scoreThresholdLastUpdatedAt;

        private String message;

        private Long computeTime;

        private Date finishedAt;

        private Date startedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(MLModel model) {
            setMLModelId(model.mlModelId);
            setTrainingDataSourceId(model.trainingDataSourceId);
            setCreatedByIamUser(model.createdByIamUser);
            setCreatedAt(model.createdAt);
            setLastUpdatedAt(model.lastUpdatedAt);
            setName(model.name);
            setStatus(model.status);
            setSizeInBytes(model.sizeInBytes);
            setEndpointInfo(model.endpointInfo);
            setTrainingParameters(model.trainingParameters);
            setInputDataLocationS3(model.inputDataLocationS3);
            setAlgorithm(model.algorithm);
            setMLModelType(model.mlModelType);
            setScoreThreshold(model.scoreThreshold);
            setScoreThresholdLastUpdatedAt(model.scoreThresholdLastUpdatedAt);
            setMessage(model.message);
            setComputeTime(model.computeTime);
            setFinishedAt(model.finishedAt);
            setStartedAt(model.startedAt);
        }

        public final String getMLModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMLModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        public final String getTrainingDataSourceId() {
            return trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        public final String getCreatedByIamUser() {
            return createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        public final Date getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy(createdAt);
            return this;
        }

        public final void setCreatedAt(Date createdAt) {
            this.createdAt = StandardMemberCopier.copy(createdAt);
        }

        public final Date getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Date lastUpdatedAt) {
            this.lastUpdatedAt = StandardMemberCopier.copy(lastUpdatedAt);
            return this;
        }

        public final void setLastUpdatedAt(Date lastUpdatedAt) {
            this.lastUpdatedAt = StandardMemberCopier.copy(lastUpdatedAt);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(EntityStatus status) {
            this.status(status.toString());
        }

        public final Long getSizeInBytes() {
            return sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final RealtimeEndpointInfo getEndpointInfo() {
            return endpointInfo;
        }

        @Override
        public final Builder endpointInfo(RealtimeEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public final void setEndpointInfo(RealtimeEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
        }

        public final Map<String, String> getTrainingParameters() {
            return trainingParameters;
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        public final String getInputDataLocationS3() {
            return inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        public final String getAlgorithm() {
            return algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm(algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final void setAlgorithm(Algorithm algorithm) {
            this.algorithm(algorithm.toString());
        }

        public final String getMLModelType() {
            return mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType.toString());
            return this;
        }

        public final void setMLModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        public final void setMLModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType.toString());
        }

        public final Float getScoreThreshold() {
            return scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        public final Date getScoreThresholdLastUpdatedAt() {
            return scoreThresholdLastUpdatedAt;
        }

        @Override
        public final Builder scoreThresholdLastUpdatedAt(Date scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = StandardMemberCopier.copy(scoreThresholdLastUpdatedAt);
            return this;
        }

        public final void setScoreThresholdLastUpdatedAt(Date scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = StandardMemberCopier.copy(scoreThresholdLastUpdatedAt);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Long getComputeTime() {
            return computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        public final Date getFinishedAt() {
            return finishedAt;
        }

        @Override
        public final Builder finishedAt(Date finishedAt) {
            this.finishedAt = StandardMemberCopier.copy(finishedAt);
            return this;
        }

        public final void setFinishedAt(Date finishedAt) {
            this.finishedAt = StandardMemberCopier.copy(finishedAt);
        }

        public final Date getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Date startedAt) {
            this.startedAt = StandardMemberCopier.copy(startedAt);
            return this;
        }

        public final void setStartedAt(Date startedAt) {
            this.startedAt = StandardMemberCopier.copy(startedAt);
        }

        @Override
        public MLModel build() {
            return new MLModel(this);
        }
    }
}
