/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDataSourceFromRedshiftRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDataSourceFromRedshiftRequest.Builder, CreateDataSourceFromRedshiftRequest> {
    private final String dataSourceId;

    private final String dataSourceName;

    private final RedshiftDataSpec dataSpec;

    private final String roleARN;

    private final Boolean computeStatistics;

    private CreateDataSourceFromRedshiftRequest(BuilderImpl builder) {
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceName = builder.dataSourceName;
        this.dataSpec = builder.dataSpec;
        this.roleARN = builder.roleARN;
        this.computeStatistics = builder.computeStatistics;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>DataSource</code>.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A user-supplied name or description of the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied name or description of the <code>DataSource</code>.
     */
    public String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The data specification of an Amazon Redshift <code>DataSource</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DatabaseInformation -
     * <ul>
     * <li> <code>DatabaseName</code> - The name of the Amazon Redshift database.</li>
     * <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li>
     * </ul>
     * </p>
     * </li>
     * <li>
     * <p>
     * DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the
     * Amazon Redshift database.
     * </p>
     * </li>
     * <li>
     * <p>
     * SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift data. The
     * data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in this location.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     * specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     * <code>DataSource</code>.
     * </p>
     * <p>
     * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The data specification of an Amazon Redshift <code>DataSource</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DatabaseInformation -
     *         <ul>
     *         <li> <code>DatabaseName</code> - The name of the Amazon Redshift database.</li>
     *         <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li>
     *         </ul>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect
     *         to the Amazon Redshift database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift
     *         data. The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in
     *         this location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
     *         specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
     *         <code>DataSource</code>.
     *         </p>
     *         <p>
     *         Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
     *         </p>
     *         </li>
     */
    public RedshiftDataSpec dataSpec() {
        return dataSpec;
    }

    /**
     * <p>
     * A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the
     * following:
     * </p>
     * <p>
     * <ul>
     * <li>
     * <p>
     * A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift
     * cluster
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
     * </p>
     * </li>
     * </ul>
     * </p>
     * 
     * @return A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to
     *         create the following: </p>
     *         <p>
     *         <ul>
     *         <li>
     *         <p>
     *         A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon
     *         Redshift cluster
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the
     *         <code>S3StagingLocation</code>
     *         </p>
     *         </li>
     *         </ul>
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
     * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
     * training. This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to be used for
     * <code>MLModel</code> training.
     * </p>
     * 
     * @return The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation
     *         data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during
     *         <code>MLModel</code> training. This parameter must be set to <code>true</code> if the
     *         <code>DataSource</code> needs to be used for <code>MLModel</code> training.
     */
    public Boolean computeStatistics() {
        return computeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataSourceId() == null) ? 0 : dataSourceId().hashCode());
        hashCode = 31 * hashCode + ((dataSourceName() == null) ? 0 : dataSourceName().hashCode());
        hashCode = 31 * hashCode + ((dataSpec() == null) ? 0 : dataSpec().hashCode());
        hashCode = 31 * hashCode + ((roleARN() == null) ? 0 : roleARN().hashCode());
        hashCode = 31 * hashCode + ((computeStatistics() == null) ? 0 : computeStatistics().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceFromRedshiftRequest)) {
            return false;
        }
        CreateDataSourceFromRedshiftRequest other = (CreateDataSourceFromRedshiftRequest) obj;
        if (other.dataSourceId() == null ^ this.dataSourceId() == null) {
            return false;
        }
        if (other.dataSourceId() != null && !other.dataSourceId().equals(this.dataSourceId())) {
            return false;
        }
        if (other.dataSourceName() == null ^ this.dataSourceName() == null) {
            return false;
        }
        if (other.dataSourceName() != null && !other.dataSourceName().equals(this.dataSourceName())) {
            return false;
        }
        if (other.dataSpec() == null ^ this.dataSpec() == null) {
            return false;
        }
        if (other.dataSpec() != null && !other.dataSpec().equals(this.dataSpec())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.computeStatistics() == null ^ this.computeStatistics() == null) {
            return false;
        }
        if (other.computeStatistics() != null && !other.computeStatistics().equals(this.computeStatistics())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dataSourceId() != null) {
            sb.append("DataSourceId: ").append(dataSourceId()).append(",");
        }
        if (dataSourceName() != null) {
            sb.append("DataSourceName: ").append(dataSourceName()).append(",");
        }
        if (dataSpec() != null) {
            sb.append("DataSpec: ").append(dataSpec()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (computeStatistics() != null) {
            sb.append("ComputeStatistics: ").append(computeStatistics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDataSourceFromRedshiftRequest> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceId
         *        A user-supplied ID that uniquely identifies the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A user-supplied name or description of the <code>DataSource</code>.
         * </p>
         * 
         * @param dataSourceName
         *        A user-supplied name or description of the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The data specification of an Amazon Redshift <code>DataSource</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DatabaseInformation -
         * <ul>
         * <li> <code>DatabaseName</code> - The name of the Amazon Redshift database.</li>
         * <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li>
         * </ul>
         * </p>
         * </li>
         * <li>
         * <p>
         * DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to
         * the Amazon Redshift database.
         * </p>
         * </li>
         * <li>
         * <p>
         * SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift data.
         * The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in this
         * location.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is
         * specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         * <code>DataSource</code>.
         * </p>
         * <p>
         * Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataSpec
         *        The data specification of an Amazon Redshift <code>DataSource</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DatabaseInformation -
         *        <ul>
         *        <li> <code>DatabaseName</code> - The name of the Amazon Redshift database.</li>
         *        <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li>
         *        </ul>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to
         *        connect to the Amazon Redshift database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SelectSqlQuery - The query that is used to retrieve the observation data for the
         *        <code>Datasource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift
         *        data. The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in
         *        this location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code>
         *        is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the
         *        <code>DataSource</code>.
         *        </p>
         *        <p>
         *        Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSpec(RedshiftDataSpec dataSpec);

        /**
         * <p>
         * A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create
         * the following:
         * </p>
         * <p>
         * <ul>
         * <li>
         * <p>
         * A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift
         * cluster
         * </p>
         * </li>
         * <li>
         * <p>
         * An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
         * </p>
         * </li>
         * </ul>
         * </p>
         * 
         * @param roleARN
         *        A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to
         *        create the following: </p>
         *        <p>
         *        <ul>
         *        <li>
         *        <p>
         *        A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon
         *        Redshift cluster
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the
         *        <code>S3StagingLocation</code>
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data
         * referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code>
         * training. This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to be used for
         * <code>MLModel</code> training.
         * </p>
         * 
         * @param computeStatistics
         *        The compute statistics for a <code>DataSource</code>. The statistics are generated from the
         *        observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally
         *        during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the
         *        <code>DataSource</code> needs to be used for <code>MLModel</code> training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeStatistics(Boolean computeStatistics);
    }

    private static final class BuilderImpl implements Builder {
        private String dataSourceId;

        private String dataSourceName;

        private RedshiftDataSpec dataSpec;

        private String roleARN;

        private Boolean computeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceFromRedshiftRequest model) {
            setDataSourceId(model.dataSourceId);
            setDataSourceName(model.dataSourceName);
            setDataSpec(model.dataSpec);
            setRoleARN(model.roleARN);
            setComputeStatistics(model.computeStatistics);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final RedshiftDataSpec getDataSpec() {
            return dataSpec;
        }

        @Override
        public final Builder dataSpec(RedshiftDataSpec dataSpec) {
            this.dataSpec = dataSpec;
            return this;
        }

        public final void setDataSpec(RedshiftDataSpec dataSpec) {
            this.dataSpec = dataSpec;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Boolean getComputeStatistics() {
            return computeStatistics;
        }

        @Override
        public final Builder computeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
            return this;
        }

        public final void setComputeStatistics(Boolean computeStatistics) {
            this.computeStatistics = computeStatistics;
        }

        @Override
        public CreateDataSourceFromRedshiftRequest build() {
            return new CreateDataSourceFromRedshiftRequest(this);
        }
    }
}
