/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2AsyncClient;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.DataSetSummary;
import software.amazon.awssdk.services.m2.model.ListDataSetsRequest;
import software.amazon.awssdk.services.m2.model.ListDataSetsResponse;

public class ListDataSetsPublisher
implements SdkPublisher<ListDataSetsResponse> {
    private final M2AsyncClient client;
    private final ListDataSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSetsPublisher(M2AsyncClient client, ListDataSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSetsPublisher(M2AsyncClient client, ListDataSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSetSummary> dataSets() {
        Function<ListDataSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSets() != null) {
                return response.dataSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataSetsResponseFetcher
    implements AsyncPageFetcher<ListDataSetsResponse> {
        private ListDataSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSetsResponse> nextPage(ListDataSetsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetsPublisher.this.client.listDataSets(ListDataSetsPublisher.this.firstRequest);
            }
            return ListDataSetsPublisher.this.client.listDataSets((ListDataSetsRequest)((Object)ListDataSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

