/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.TimeSeriesFeedback;
import software.amazon.awssdk.services.lookoutmetrics.model.TimeSeriesFeedbackListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFeedbackResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, GetFeedbackResponse> {
    private static final SdkField<List<TimeSeriesFeedback>> ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnomalyGroupTimeSeriesFeedback").getter(GetFeedbackResponse.getter(GetFeedbackResponse::anomalyGroupTimeSeriesFeedback)).setter(GetFeedbackResponse.setter(Builder::anomalyGroupTimeSeriesFeedback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupTimeSeriesFeedback").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesFeedback::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetFeedbackResponse.getter(GetFeedbackResponse::nextToken)).setter(GetFeedbackResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFeedbackResponse.memberNameToFieldInitializer();
    private final List<TimeSeriesFeedback> anomalyGroupTimeSeriesFeedback;
    private final String nextToken;

    private GetFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyGroupTimeSeriesFeedback = builder.anomalyGroupTimeSeriesFeedback;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnomalyGroupTimeSeriesFeedback() {
        return this.anomalyGroupTimeSeriesFeedback != null && !(this.anomalyGroupTimeSeriesFeedback instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesFeedback> anomalyGroupTimeSeriesFeedback() {
        return this.anomalyGroupTimeSeriesFeedback;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalyGroupTimeSeriesFeedback() ? this.anomalyGroupTimeSeriesFeedback() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFeedbackResponse)) {
            return false;
        }
        GetFeedbackResponse other = (GetFeedbackResponse)((Object)obj);
        return this.hasAnomalyGroupTimeSeriesFeedback() == other.hasAnomalyGroupTimeSeriesFeedback() && Objects.equals(this.anomalyGroupTimeSeriesFeedback(), other.anomalyGroupTimeSeriesFeedback()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetFeedbackResponse").add("AnomalyGroupTimeSeriesFeedback", this.hasAnomalyGroupTimeSeriesFeedback() ? this.anomalyGroupTimeSeriesFeedback() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyGroupTimeSeriesFeedback": {
                return Optional.ofNullable(clazz.cast(this.anomalyGroupTimeSeriesFeedback()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AnomalyGroupTimeSeriesFeedback", ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFeedbackResponse, T> g) {
        return obj -> g.apply((GetFeedbackResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private List<TimeSeriesFeedback> anomalyGroupTimeSeriesFeedback = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFeedbackResponse model) {
            super(model);
            this.anomalyGroupTimeSeriesFeedback(model.anomalyGroupTimeSeriesFeedback);
            this.nextToken(model.nextToken);
        }

        public final List<TimeSeriesFeedback.Builder> getAnomalyGroupTimeSeriesFeedback() {
            List<TimeSeriesFeedback.Builder> result = TimeSeriesFeedbackListCopier.copyToBuilder(this.anomalyGroupTimeSeriesFeedback);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalyGroupTimeSeriesFeedback(Collection<TimeSeriesFeedback.BuilderImpl> anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback = TimeSeriesFeedbackListCopier.copyFromBuilder(anomalyGroupTimeSeriesFeedback);
        }

        @Override
        public final Builder anomalyGroupTimeSeriesFeedback(Collection<TimeSeriesFeedback> anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback = TimeSeriesFeedbackListCopier.copy(anomalyGroupTimeSeriesFeedback);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyGroupTimeSeriesFeedback(TimeSeriesFeedback ... anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback(Arrays.asList(anomalyGroupTimeSeriesFeedback));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyGroupTimeSeriesFeedback(Consumer<TimeSeriesFeedback.Builder> ... anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback(Stream.of(anomalyGroupTimeSeriesFeedback).map(c -> (TimeSeriesFeedback)((TimeSeriesFeedback.Builder)TimeSeriesFeedback.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetFeedbackResponse build() {
            return new GetFeedbackResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFeedbackResponse> {
        public Builder anomalyGroupTimeSeriesFeedback(Collection<TimeSeriesFeedback> var1);

        public Builder anomalyGroupTimeSeriesFeedback(TimeSeriesFeedback ... var1);

        public Builder anomalyGroupTimeSeriesFeedback(Consumer<TimeSeriesFeedback.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

