/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.DetectedField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectedCsvFormatDescriptor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectedCsvFormatDescriptor> {
    private static final SdkField<DetectedField> FILE_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FileCompression").getter(DetectedCsvFormatDescriptor.getter(DetectedCsvFormatDescriptor::fileCompression)).setter(DetectedCsvFormatDescriptor.setter(Builder::fileCompression)).constructor(DetectedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCompression").build()}).build();
    private static final SdkField<DetectedField> CHARSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Charset").getter(DetectedCsvFormatDescriptor.getter(DetectedCsvFormatDescriptor::charset)).setter(DetectedCsvFormatDescriptor.setter(Builder::charset)).constructor(DetectedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Charset").build()}).build();
    private static final SdkField<DetectedField> CONTAINS_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainsHeader").getter(DetectedCsvFormatDescriptor.getter(DetectedCsvFormatDescriptor::containsHeader)).setter(DetectedCsvFormatDescriptor.setter(Builder::containsHeader)).constructor(DetectedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsHeader").build()}).build();
    private static final SdkField<DetectedField> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Delimiter").getter(DetectedCsvFormatDescriptor.getter(DetectedCsvFormatDescriptor::delimiter)).setter(DetectedCsvFormatDescriptor.setter(Builder::delimiter)).constructor(DetectedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()}).build();
    private static final SdkField<DetectedField> HEADER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HeaderList").getter(DetectedCsvFormatDescriptor.getter(DetectedCsvFormatDescriptor::headerList)).setter(DetectedCsvFormatDescriptor.setter(Builder::headerList)).constructor(DetectedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderList").build()}).build();
    private static final SdkField<DetectedField> QUOTE_SYMBOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QuoteSymbol").getter(DetectedCsvFormatDescriptor.getter(DetectedCsvFormatDescriptor::quoteSymbol)).setter(DetectedCsvFormatDescriptor.setter(Builder::quoteSymbol)).constructor(DetectedField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteSymbol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_COMPRESSION_FIELD, CHARSET_FIELD, CONTAINS_HEADER_FIELD, DELIMITER_FIELD, HEADER_LIST_FIELD, QUOTE_SYMBOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectedCsvFormatDescriptor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DetectedField fileCompression;
    private final DetectedField charset;
    private final DetectedField containsHeader;
    private final DetectedField delimiter;
    private final DetectedField headerList;
    private final DetectedField quoteSymbol;

    private DetectedCsvFormatDescriptor(BuilderImpl builder) {
        this.fileCompression = builder.fileCompression;
        this.charset = builder.charset;
        this.containsHeader = builder.containsHeader;
        this.delimiter = builder.delimiter;
        this.headerList = builder.headerList;
        this.quoteSymbol = builder.quoteSymbol;
    }

    public final DetectedField fileCompression() {
        return this.fileCompression;
    }

    public final DetectedField charset() {
        return this.charset;
    }

    public final DetectedField containsHeader() {
        return this.containsHeader;
    }

    public final DetectedField delimiter() {
        return this.delimiter;
    }

    public final DetectedField headerList() {
        return this.headerList;
    }

    public final DetectedField quoteSymbol() {
        return this.quoteSymbol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCompression());
        hashCode = 31 * hashCode + Objects.hashCode(this.charset());
        hashCode = 31 * hashCode + Objects.hashCode(this.containsHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.headerList());
        hashCode = 31 * hashCode + Objects.hashCode(this.quoteSymbol());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedCsvFormatDescriptor)) {
            return false;
        }
        DetectedCsvFormatDescriptor other = (DetectedCsvFormatDescriptor)obj;
        return Objects.equals(this.fileCompression(), other.fileCompression()) && Objects.equals(this.charset(), other.charset()) && Objects.equals(this.containsHeader(), other.containsHeader()) && Objects.equals(this.delimiter(), other.delimiter()) && Objects.equals(this.headerList(), other.headerList()) && Objects.equals(this.quoteSymbol(), other.quoteSymbol());
    }

    public final String toString() {
        return ToString.builder((String)"DetectedCsvFormatDescriptor").add("FileCompression", (Object)this.fileCompression()).add("Charset", (Object)this.charset()).add("ContainsHeader", (Object)this.containsHeader()).add("Delimiter", (Object)this.delimiter()).add("HeaderList", (Object)this.headerList()).add("QuoteSymbol", (Object)this.quoteSymbol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileCompression": {
                return Optional.ofNullable(clazz.cast(this.fileCompression()));
            }
            case "Charset": {
                return Optional.ofNullable(clazz.cast(this.charset()));
            }
            case "ContainsHeader": {
                return Optional.ofNullable(clazz.cast(this.containsHeader()));
            }
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "HeaderList": {
                return Optional.ofNullable(clazz.cast(this.headerList()));
            }
            case "QuoteSymbol": {
                return Optional.ofNullable(clazz.cast(this.quoteSymbol()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DetectedField>> map = new HashMap<String, SdkField<DetectedField>>();
        map.put("FileCompression", FILE_COMPRESSION_FIELD);
        map.put("Charset", CHARSET_FIELD);
        map.put("ContainsHeader", CONTAINS_HEADER_FIELD);
        map.put("Delimiter", DELIMITER_FIELD);
        map.put("HeaderList", HEADER_LIST_FIELD);
        map.put("QuoteSymbol", QUOTE_SYMBOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectedCsvFormatDescriptor, T> g) {
        return obj -> g.apply((DetectedCsvFormatDescriptor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DetectedField fileCompression;
        private DetectedField charset;
        private DetectedField containsHeader;
        private DetectedField delimiter;
        private DetectedField headerList;
        private DetectedField quoteSymbol;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedCsvFormatDescriptor model) {
            this.fileCompression(model.fileCompression);
            this.charset(model.charset);
            this.containsHeader(model.containsHeader);
            this.delimiter(model.delimiter);
            this.headerList(model.headerList);
            this.quoteSymbol(model.quoteSymbol);
        }

        public final DetectedField.Builder getFileCompression() {
            return this.fileCompression != null ? this.fileCompression.toBuilder() : null;
        }

        public final void setFileCompression(DetectedField.BuilderImpl fileCompression) {
            this.fileCompression = fileCompression != null ? fileCompression.build() : null;
        }

        @Override
        public final Builder fileCompression(DetectedField fileCompression) {
            this.fileCompression = fileCompression;
            return this;
        }

        public final DetectedField.Builder getCharset() {
            return this.charset != null ? this.charset.toBuilder() : null;
        }

        public final void setCharset(DetectedField.BuilderImpl charset) {
            this.charset = charset != null ? charset.build() : null;
        }

        @Override
        public final Builder charset(DetectedField charset) {
            this.charset = charset;
            return this;
        }

        public final DetectedField.Builder getContainsHeader() {
            return this.containsHeader != null ? this.containsHeader.toBuilder() : null;
        }

        public final void setContainsHeader(DetectedField.BuilderImpl containsHeader) {
            this.containsHeader = containsHeader != null ? containsHeader.build() : null;
        }

        @Override
        public final Builder containsHeader(DetectedField containsHeader) {
            this.containsHeader = containsHeader;
            return this;
        }

        public final DetectedField.Builder getDelimiter() {
            return this.delimiter != null ? this.delimiter.toBuilder() : null;
        }

        public final void setDelimiter(DetectedField.BuilderImpl delimiter) {
            this.delimiter = delimiter != null ? delimiter.build() : null;
        }

        @Override
        public final Builder delimiter(DetectedField delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final DetectedField.Builder getHeaderList() {
            return this.headerList != null ? this.headerList.toBuilder() : null;
        }

        public final void setHeaderList(DetectedField.BuilderImpl headerList) {
            this.headerList = headerList != null ? headerList.build() : null;
        }

        @Override
        public final Builder headerList(DetectedField headerList) {
            this.headerList = headerList;
            return this;
        }

        public final DetectedField.Builder getQuoteSymbol() {
            return this.quoteSymbol != null ? this.quoteSymbol.toBuilder() : null;
        }

        public final void setQuoteSymbol(DetectedField.BuilderImpl quoteSymbol) {
            this.quoteSymbol = quoteSymbol != null ? quoteSymbol.build() : null;
        }

        @Override
        public final Builder quoteSymbol(DetectedField quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
            return this;
        }

        public DetectedCsvFormatDescriptor build() {
            return new DetectedCsvFormatDescriptor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectedCsvFormatDescriptor> {
        public Builder fileCompression(DetectedField var1);

        default public Builder fileCompression(Consumer<DetectedField.Builder> fileCompression) {
            return this.fileCompression((DetectedField)((DetectedField.Builder)DetectedField.builder().applyMutation(fileCompression)).build());
        }

        public Builder charset(DetectedField var1);

        default public Builder charset(Consumer<DetectedField.Builder> charset) {
            return this.charset((DetectedField)((DetectedField.Builder)DetectedField.builder().applyMutation(charset)).build());
        }

        public Builder containsHeader(DetectedField var1);

        default public Builder containsHeader(Consumer<DetectedField.Builder> containsHeader) {
            return this.containsHeader((DetectedField)((DetectedField.Builder)DetectedField.builder().applyMutation(containsHeader)).build());
        }

        public Builder delimiter(DetectedField var1);

        default public Builder delimiter(Consumer<DetectedField.Builder> delimiter) {
            return this.delimiter((DetectedField)((DetectedField.Builder)DetectedField.builder().applyMutation(delimiter)).build());
        }

        public Builder headerList(DetectedField var1);

        default public Builder headerList(Consumer<DetectedField.Builder> headerList) {
            return this.headerList((DetectedField)((DetectedField.Builder)DetectedField.builder().applyMutation(headerList)).build());
        }

        public Builder quoteSymbol(DetectedField var1);

        default public Builder quoteSymbol(Consumer<DetectedField.Builder> quoteSymbol) {
            return this.quoteSymbol((DetectedField)((DetectedField.Builder)DetectedField.builder().applyMutation(quoteSymbol)).build());
        }
    }
}

