/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.Frequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyDetectorConfigSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyDetectorConfigSummary> {
    private static final SdkField<String> ANOMALY_DETECTOR_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorFrequency").getter(AnomalyDetectorConfigSummary.getter(AnomalyDetectorConfigSummary::anomalyDetectorFrequencyAsString)).setter(AnomalyDetectorConfigSummary.setter(Builder::anomalyDetectorFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorFrequency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_FREQUENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnomalyDetectorConfigSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String anomalyDetectorFrequency;

    private AnomalyDetectorConfigSummary(BuilderImpl builder) {
        this.anomalyDetectorFrequency = builder.anomalyDetectorFrequency;
    }

    public final Frequency anomalyDetectorFrequency() {
        return Frequency.fromValue(this.anomalyDetectorFrequency);
    }

    public final String anomalyDetectorFrequencyAsString() {
        return this.anomalyDetectorFrequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorFrequencyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetectorConfigSummary)) {
            return false;
        }
        AnomalyDetectorConfigSummary other = (AnomalyDetectorConfigSummary)obj;
        return Objects.equals(this.anomalyDetectorFrequencyAsString(), other.anomalyDetectorFrequencyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyDetectorConfigSummary").add("AnomalyDetectorFrequency", (Object)this.anomalyDetectorFrequencyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorFrequency": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorFrequencyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AnomalyDetectorFrequency", ANOMALY_DETECTOR_FREQUENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetectorConfigSummary, T> g) {
        return obj -> g.apply((AnomalyDetectorConfigSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String anomalyDetectorFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetectorConfigSummary model) {
            this.anomalyDetectorFrequency(model.anomalyDetectorFrequency);
        }

        public final String getAnomalyDetectorFrequency() {
            return this.anomalyDetectorFrequency;
        }

        public final void setAnomalyDetectorFrequency(String anomalyDetectorFrequency) {
            this.anomalyDetectorFrequency = anomalyDetectorFrequency;
        }

        @Override
        public final Builder anomalyDetectorFrequency(String anomalyDetectorFrequency) {
            this.anomalyDetectorFrequency = anomalyDetectorFrequency;
            return this;
        }

        @Override
        public final Builder anomalyDetectorFrequency(Frequency anomalyDetectorFrequency) {
            this.anomalyDetectorFrequency(anomalyDetectorFrequency == null ? null : anomalyDetectorFrequency.toString());
            return this;
        }

        public AnomalyDetectorConfigSummary build() {
            return new AnomalyDetectorConfigSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyDetectorConfigSummary> {
        public Builder anomalyDetectorFrequency(String var1);

        public Builder anomalyDetectorFrequency(Frequency var1);
    }
}

