/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A calculation made by contrasting a measure and a dimension from your source data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Metric implements SdkPojo, Serializable, ToCopyableBuilder<Metric.Builder, Metric> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(Metric::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> AGGREGATION_FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregationFunction").getter(getter(Metric::aggregationFunctionAsString))
            .setter(setter(Builder::aggregationFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build())
            .build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(Metric::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            AGGREGATION_FUNCTION_FIELD, NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String aggregationFunction;

    private final String namespace;

    private Metric(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.aggregationFunction = builder.aggregationFunction;
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The function with which the metric is calculated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationFunction} will return {@link AggregationFunction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationFunctionAsString}.
     * </p>
     * 
     * @return The function with which the metric is calculated.
     * @see AggregationFunction
     */
    public final AggregationFunction aggregationFunction() {
        return AggregationFunction.fromValue(aggregationFunction);
    }

    /**
     * <p>
     * The function with which the metric is calculated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationFunction} will return {@link AggregationFunction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #aggregationFunctionAsString}.
     * </p>
     * 
     * @return The function with which the metric is calculated.
     * @see AggregationFunction
     */
    public final String aggregationFunctionAsString() {
        return aggregationFunction;
    }

    /**
     * <p>
     * The namespace for the metric.
     * </p>
     * 
     * @return The namespace for the metric.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric other = (Metric) obj;
        return Objects.equals(metricName(), other.metricName())
                && Objects.equals(aggregationFunctionAsString(), other.aggregationFunctionAsString())
                && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Metric").add("MetricName", metricName())
                .add("AggregationFunction", aggregationFunctionAsString()).add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "AggregationFunction":
            return Optional.ofNullable(clazz.cast(aggregationFunctionAsString()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Metric, T> g) {
        return obj -> g.apply((Metric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Metric> {
        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The function with which the metric is calculated.
         * </p>
         * 
         * @param aggregationFunction
         *        The function with which the metric is calculated.
         * @see AggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationFunction
         */
        Builder aggregationFunction(String aggregationFunction);

        /**
         * <p>
         * The function with which the metric is calculated.
         * </p>
         * 
         * @param aggregationFunction
         *        The function with which the metric is calculated.
         * @see AggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationFunction
         */
        Builder aggregationFunction(AggregationFunction aggregationFunction);

        /**
         * <p>
         * The namespace for the metric.
         * </p>
         * 
         * @param namespace
         *        The namespace for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String aggregationFunction;

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(Metric model) {
            metricName(model.metricName);
            aggregationFunction(model.aggregationFunction);
            namespace(model.namespace);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getAggregationFunction() {
            return aggregationFunction;
        }

        public final void setAggregationFunction(String aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
        }

        @Override
        public final Builder aggregationFunction(String aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction(aggregationFunction == null ? null : aggregationFunction.toString());
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public Metric build() {
            return new Metric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
