/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAlertsResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<ListAlertsResponse.Builder, ListAlertsResponse> {
    private static final SdkField<List<AlertSummary>> ALERT_SUMMARY_LIST_FIELD = SdkField
            .<List<AlertSummary>> builder(MarshallingType.LIST)
            .memberName("AlertSummaryList")
            .getter(getter(ListAlertsResponse::alertSummaryList))
            .setter(setter(Builder::alertSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlertSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlertSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAlertsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AlertSummary> alertSummaryList;

    private final String nextToken;

    private ListAlertsResponse(BuilderImpl builder) {
        super(builder);
        this.alertSummaryList = builder.alertSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlertSummaryList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlertSummaryList() {
        return alertSummaryList != null && !(alertSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about an alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlertSummaryList} method.
     * </p>
     * 
     * @return Contains information about an alert.
     */
    public final List<AlertSummary> alertSummaryList() {
        return alertSummaryList;
    }

    /**
     * <p>
     * If the response is truncated, the service returns this token. To retrieve the next set of results, use this token
     * in the next request.
     * </p>
     * 
     * @return If the response is truncated, the service returns this token. To retrieve the next set of results, use
     *         this token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAlertSummaryList() ? alertSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlertsResponse)) {
            return false;
        }
        ListAlertsResponse other = (ListAlertsResponse) obj;
        return hasAlertSummaryList() == other.hasAlertSummaryList()
                && Objects.equals(alertSummaryList(), other.alertSummaryList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAlertsResponse").add("AlertSummaryList", hasAlertSummaryList() ? alertSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlertSummaryList":
            return Optional.ofNullable(clazz.cast(alertSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AlertSummaryList", ALERT_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAlertsResponse, T> g) {
        return obj -> g.apply((ListAlertsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAlertsResponse> {
        /**
         * <p>
         * Contains information about an alert.
         * </p>
         * 
         * @param alertSummaryList
         *        Contains information about an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertSummaryList(Collection<AlertSummary> alertSummaryList);

        /**
         * <p>
         * Contains information about an alert.
         * </p>
         * 
         * @param alertSummaryList
         *        Contains information about an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertSummaryList(AlertSummary... alertSummaryList);

        /**
         * <p>
         * Contains information about an alert.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.AlertSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lookoutmetrics.model.AlertSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutmetrics.model.AlertSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #alertSummaryList(List<AlertSummary>)}.
         * 
         * @param alertSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutmetrics.model.AlertSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alertSummaryList(java.util.Collection<AlertSummary>)
         */
        Builder alertSummaryList(Consumer<AlertSummary.Builder>... alertSummaryList);

        /**
         * <p>
         * If the response is truncated, the service returns this token. To retrieve the next set of results, use this
         * token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, the service returns this token. To retrieve the next set of results, use
         *        this token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private List<AlertSummary> alertSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlertsResponse model) {
            super(model);
            alertSummaryList(model.alertSummaryList);
            nextToken(model.nextToken);
        }

        public final List<AlertSummary.Builder> getAlertSummaryList() {
            List<AlertSummary.Builder> result = AlertSummaryListCopier.copyToBuilder(this.alertSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlertSummaryList(Collection<AlertSummary.BuilderImpl> alertSummaryList) {
            this.alertSummaryList = AlertSummaryListCopier.copyFromBuilder(alertSummaryList);
        }

        @Override
        public final Builder alertSummaryList(Collection<AlertSummary> alertSummaryList) {
            this.alertSummaryList = AlertSummaryListCopier.copy(alertSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alertSummaryList(AlertSummary... alertSummaryList) {
            alertSummaryList(Arrays.asList(alertSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alertSummaryList(Consumer<AlertSummary.Builder>... alertSummaryList) {
            alertSummaryList(Stream.of(alertSummaryList).map(c -> AlertSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAlertsResponse build() {
            return new ListAlertsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
